/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AbstractAdapterMapperGenerator;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public abstract class IocAdapterMapperGenerator
extends AbstractAdapterMapperGenerator {
    protected abstract AnnotationSpec componentAnnotation();

    protected abstract List<AnnotationSpec> injectAnnotations();

    @Override
    protected TypeSpec createTypeSpec(Collection<AbstractAdapterMethodMetadata> adapterMethods, String adapterClassName) {
        TypeSpec.Builder adapterBuilder = TypeSpec.classBuilder((ClassName)ClassName.get((String)this.adapterPackage(), (String)adapterClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.componentAnnotation());
        adapterMethods.stream().filter(adapterMethodMetadata -> !adapterMethodMetadata.isStatic()).map(AbstractAdapterMethodMetadata::getMapper).distinct().forEach(mapper -> adapterBuilder.addField(this.buildMapperField((ClassName)mapper)));
        adapterMethods.forEach(adapterMethod -> adapterBuilder.addMethod(this.buildProxyMethod((AbstractAdapterMethodMetadata)adapterMethod)));
        return adapterBuilder.build();
    }

    private FieldSpec buildMapperField(ClassName mapper) {
        return FieldSpec.builder((TypeName)mapper, (String)this.firstWordToLower(mapper.simpleName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotations(this.injectAnnotations()).build();
    }

    private String firstWordToLower(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    @Override
    protected CodeBlock proxyMethodTarget(AbstractAdapterMethodMetadata adapterMethodMetadata) {
        return CodeBlock.builder().add("return $N.$N($N);", new Object[]{this.firstWordToLower(adapterMethodMetadata.getMapper().simpleName()), adapterMethodMetadata.getMapperMethodName(), "param"}).build();
    }
}

