/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.query;

import io.github.javpower.vectorex.keynote.index.scalar.RangeCondition;
import io.github.javpower.vectorex.keynote.model.ConditionFiled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConditionBuilder {
    private final List<Predicate<Map<String, Object>>> conditions = new ArrayList<Predicate<Map<String, Object>>>();
    private final List<RangeCondition> rangeConditions = new ArrayList<RangeCondition>();
    private final Map<String, Object> indexConditions = new HashMap<String, Object>();
    private final List<ConditionFiled> operations = new ArrayList<ConditionFiled>();

    public ConditionBuilder eq(String field, Object value) {
        this.addCondition(field, value, (fieldValue, val) -> Objects.equals(fieldValue, val), "eq");
        this.indexConditions.put(field, value);
        return this;
    }

    public ConditionBuilder ne(String field, Object value) {
        this.addCondition(field, value, (fieldValue, val) -> !Objects.equals(fieldValue, val), "ne");
        return this;
    }

    public ConditionBuilder gt(String field, Comparable<?> value) {
        this.rangeConditions.add(new RangeCondition(value, null, false, false));
        this.operations.add(new ConditionFiled("gt", field, value));
        return this;
    }

    public ConditionBuilder ge(String field, Comparable<?> value) {
        this.rangeConditions.add(new RangeCondition(value, null, true, false));
        this.operations.add(new ConditionFiled("ge", field, value));
        return this;
    }

    public ConditionBuilder lt(String field, Comparable<?> value) {
        this.rangeConditions.add(new RangeCondition(null, value, false, false));
        this.operations.add(new ConditionFiled("lt", field, value));
        return this;
    }

    public ConditionBuilder le(String field, Comparable<?> value) {
        this.rangeConditions.add(new RangeCondition(null, value, false, true));
        this.operations.add(new ConditionFiled("le", field, value));
        return this;
    }

    public ConditionBuilder between(String field, Comparable<?> start, Comparable<?> end) {
        this.rangeConditions.add(new RangeCondition(start, end, true, true));
        this.operations.add(new ConditionFiled("between", field, Arrays.asList(start, end)));
        return this;
    }

    public ConditionBuilder in(String field, List<?> values) {
        this.conditions.add(entity -> {
            Object fieldValue = entity.get(field);
            return values.contains(fieldValue);
        });
        this.operations.add(new ConditionFiled("in", field, values));
        return this;
    }

    public ConditionBuilder like(String field, String value) {
        this.conditions.add(entity -> {
            Object fieldValue = entity.get(field);
            return fieldValue != null && fieldValue.toString().contains(value);
        });
        this.operations.add(new ConditionFiled("like", field, value));
        return this;
    }

    public ConditionBuilder and(ConditionBuilder other) {
        this.conditions.addAll(other.conditions);
        this.rangeConditions.addAll(other.rangeConditions);
        this.indexConditions.putAll(other.indexConditions);
        this.operations.add(new ConditionFiled("and", other));
        return this;
    }

    public ConditionBuilder or(ConditionBuilder other) {
        this.conditions.add(entity -> other.conditions.stream().anyMatch(condition -> condition.test(entity)));
        this.rangeConditions.addAll(other.rangeConditions);
        this.operations.add(new ConditionFiled("or", other));
        return this;
    }

    public Predicate<Map<String, Object>> build() {
        return entity -> this.conditions.stream().allMatch(condition -> condition.test(entity));
    }

    public List<RangeCondition> getRangeConditions() {
        return this.rangeConditions;
    }

    public Map<String, Object> getIndexConditions() {
        return this.indexConditions;
    }

    public List<ConditionFiled> getOperations() {
        return this.operations;
    }

    private <T> void addCondition(String field, T value, BiPredicate<Object, T> condition, String operation) {
        this.conditions.add(entity -> {
            Object fieldValue = entity.get(field);
            return condition.test(fieldValue, value);
        });
        this.operations.add(new ConditionFiled(operation, field, value));
    }

    @FunctionalInterface
    private static interface BiPredicate<T, U> {
        public boolean test(T var1, U var2);
    }
}

