/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn.util;

public class Murmur3 {
    private static final int C1_32 = -862048943;
    private static final int C2_32 = 461845907;
    private static final int R1_32 = 15;
    private static final int R2_32 = 13;
    private static final int M_32 = 5;
    private static final int N_32 = -430675100;
    private static final int DEFAULT_SEED = 104729;

    public static int hash32(byte[] data) {
        return Murmur3.hash32(data, 0, data.length, 104729);
    }

    public static int hash32(byte[] data, int offset, int length, int seed) {
        int hash = seed;
        int nblocks = length >> 2;
        for (int i = 0; i < nblocks; ++i) {
            int i_4 = i << 2;
            int k = data[offset + i_4] & 0xFF | (data[offset + i_4 + 1] & 0xFF) << 8 | (data[offset + i_4 + 2] & 0xFF) << 16 | (data[offset + i_4 + 3] & 0xFF) << 24;
            hash = Murmur3.mix32(k, hash);
        }
        int idx = nblocks << 2;
        int k1 = 0;
        switch (length - idx) {
            case 3: {
                k1 ^= data[offset + idx + 2] << 16;
            }
            case 2: {
                k1 ^= data[offset + idx + 1] << 8;
            }
            case 1: {
                k1 ^= data[offset + idx];
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                hash ^= (k1 *= 461845907);
            }
        }
        return Murmur3.fmix32(length, hash);
    }

    private static int mix32(int k, int hash) {
        k *= -862048943;
        k = Integer.rotateLeft(k, 15);
        return Integer.rotateLeft(hash ^= (k *= 461845907), 13) * 5 + -430675100;
    }

    private static int fmix32(int length, int hash) {
        hash ^= length;
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return hash;
    }
}

