/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn.bruteforce;

import io.github.javpower.vectorex.keynote.knn.DistanceFunction;
import io.github.javpower.vectorex.keynote.knn.Index;
import io.github.javpower.vectorex.keynote.knn.Item;
import io.github.javpower.vectorex.keynote.knn.SearchResult;
import io.github.javpower.vectorex.keynote.knn.util.ClassLoaderObjectInputStream;
import io.github.javpower.vectorex.keynote.knn.util.DummyComparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;

public class BruteForceIndex<TId, TVector, TItem extends Item<TId, TVector>, TDistance>
implements Index<TId, TVector, TItem, TDistance> {
    private static final long serialVersionUID = 1L;
    private final boolean immutable;
    private final int dimensions;
    private final DistanceFunction<TVector, TDistance> distanceFunction;
    private final Comparator<TDistance> distanceComparator;
    private final Map<TId, TItem> items;
    private final Map<TId, Long> deletedItemVersions;

    private BruteForceIndex(Builder<TVector, TDistance> builder) {
        this.immutable = ((Builder)builder).immutable;
        this.dimensions = ((Builder)builder).dimensions;
        this.distanceFunction = ((Builder)builder).distanceFunction;
        this.distanceComparator = ((Builder)builder).distanceComparator;
        this.items = new ConcurrentHashMap<TId, TItem>();
        this.deletedItemVersions = new ConcurrentHashMap<TId, Long>();
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public Optional<TItem> get(TId id) {
        return Optional.ofNullable(this.items.get(id));
    }

    @Override
    public Collection<TItem> items() {
        return this.items.values();
    }

    public int getDimensions() {
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(TItem item) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Index is immutable");
        }
        if (item.dimensions() != this.dimensions) {
            throw new IllegalArgumentException("Item does not have dimensionality of : " + this.dimensions);
        }
        Map<TId, TItem> map = this.items;
        synchronized (map) {
            Item existingItem = (Item)this.items.get(item.id());
            if (existingItem != null && item.version() < existingItem.version()) {
                return false;
            }
            if (item.version() < this.deletedItemVersions.getOrDefault(item.id(), 0L)) {
                return false;
            }
            this.items.put(item.id(), item);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(TId id, long version) {
        Map<TId, TItem> map = this.items;
        synchronized (map) {
            Item item = (Item)this.items.get(id);
            if (item == null) {
                return false;
            }
            if (version < item.version()) {
                return false;
            }
            this.items.remove(id);
            this.deletedItemVersions.put(id, version);
            return true;
        }
    }

    @Override
    public List<SearchResult<TItem, TDistance>> findNearest(TVector vector, int k) {
        SearchResult result;
        if (vector == null) {
            throw new IllegalArgumentException("Vector cannot be null.");
        }
        Comparator comparator = Comparator.naturalOrder().reversed();
        PriorityQueue queue = new PriorityQueue(k, comparator);
        for (Item item : this.items.values()) {
            TDistance distance = this.distanceFunction.distance(item.vector(), vector);
            SearchResult<Item, TDistance> searchResult = new SearchResult<Item, TDistance>(item, distance, this.distanceComparator);
            queue.add(searchResult);
            if (queue.size() <= k) continue;
            queue.poll();
        }
        ArrayList<SearchResult<TItem, TDistance>> results = new ArrayList<SearchResult<TItem, TDistance>>(queue.size());
        while ((result = (SearchResult)queue.poll()) != null) {
            results.add(0, result);
        }
        return results;
    }

    @Override
    public void save(OutputStream out) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(this);
        }
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> BruteForceIndex<TId, TVector, TItem, TDistance> load(File file) throws IOException {
        return BruteForceIndex.load(new FileInputStream(file));
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> BruteForceIndex<TId, TVector, TItem, TDistance> load(File file, ClassLoader classLoader) throws IOException {
        return BruteForceIndex.load(new FileInputStream(file), classLoader);
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> BruteForceIndex<TId, TVector, TItem, TDistance> load(Path path) throws IOException {
        return BruteForceIndex.load(Files.newInputStream(path, new OpenOption[0]));
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> BruteForceIndex<TId, TVector, TItem, TDistance> load(Path path, ClassLoader classLoader) throws IOException {
        return BruteForceIndex.load(Files.newInputStream(path, new OpenOption[0]), classLoader);
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> BruteForceIndex<TId, TVector, TItem, TDistance> load(InputStream inputStream) throws IOException {
        return BruteForceIndex.load(inputStream, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> BruteForceIndex<TId, TVector, TItem, TDistance> load(InputStream inputStream, ClassLoader classLoader) throws IOException {
        try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(classLoader, inputStream);){
            BruteForceIndex bruteForceIndex = (BruteForceIndex)ois.readObject();
            return bruteForceIndex;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not read input file.", e);
        }
    }

    public static <TVector, TDistance extends Comparable<TDistance>> Builder<TVector, TDistance> newBuilder(int dimensions, DistanceFunction<TVector, TDistance> distanceFunction) {
        Comparator distanceComparator = Comparator.naturalOrder();
        return new Builder<TVector, TDistance>(false, dimensions, distanceFunction, distanceComparator);
    }

    public static <TVector, TDistance> Builder<TVector, TDistance> newBuilder(int dimensions, DistanceFunction<TVector, TDistance> distanceFunction, Comparator<TDistance> distanceComparator) {
        return new Builder<TVector, TDistance>(false, dimensions, distanceFunction, distanceComparator);
    }

    public static <TId, TVector, TItem extends Item<TId, TVector>, TDistance> BruteForceIndex<TId, TVector, TItem, TDistance> empty() {
        Builder<Object, Object> builder = new Builder<Object, Object>(true, 0, (u, v) -> {
            throw new UnsupportedOperationException();
        }, new DummyComparator());
        return builder.build();
    }

    public static class Builder<TVector, TDistance> {
        private final int dimensions;
        private final DistanceFunction<TVector, TDistance> distanceFunction;
        private final Comparator<TDistance> distanceComparator;
        private final boolean immutable;

        Builder(boolean immutable, int dimensions, DistanceFunction<TVector, TDistance> distanceFunction, Comparator<TDistance> distanceComparator) {
            this.immutable = immutable;
            this.dimensions = dimensions;
            this.distanceFunction = distanceFunction;
            this.distanceComparator = distanceComparator;
        }

        public <TId, TItem extends Item<TId, TVector>> BruteForceIndex<TId, TVector, TItem, TDistance> build() {
            return new BruteForceIndex(this);
        }
    }
}

