/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class SearchResult<TItem, TDistance>
implements Comparable<SearchResult<TItem, TDistance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TDistance distance;
    private final TItem item;
    private final Comparator<TDistance> distanceComparator;

    public SearchResult(TItem item, TDistance distance, Comparator<TDistance> distanceComparator) {
        this.item = item;
        this.distance = distance;
        this.distanceComparator = distanceComparator;
    }

    public TItem item() {
        return this.item;
    }

    public TDistance distance() {
        return this.distance;
    }

    @Override
    public int compareTo(SearchResult<TItem, TDistance> o) {
        return this.distanceComparator.compare(this.distance, o.distance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return Objects.equals(this.distance, that.distance) && Objects.equals(this.item, that.item);
    }

    public int hashCode() {
        return Objects.hash(this.distance, this.item);
    }

    public String toString() {
        return "SearchResult{distance=" + this.distance + ", item=" + this.item + '}';
    }

    public static <TItem, TDistance extends Comparable<TDistance>> SearchResult<TItem, TDistance> create(TItem item, TDistance distance) {
        return new SearchResult<TItem, TDistance>(item, distance, Comparator.naturalOrder());
    }
}

