/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.test;

import io.github.javpower.vectorex.keynote.graph.core.GraphDB;
import io.github.javpower.vectorex.keynote.graph.entity.Node;
import io.github.javpower.vectorex.keynote.graph.entity.Relationship;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class SocialNetwork {
    private final GraphDB graphDB;

    public SocialNetwork(String dbPath) {
        this.graphDB = new GraphDB(dbPath);
    }

    public static void main(String[] args) {
        SocialNetwork network = new SocialNetwork("social_network.db");
        List<Node> users = Arrays.asList(SocialNetwork.createUser("Alice", "\u7231\u4e3d\u4e1d"), SocialNetwork.createUser("Bob", "\u9c8d\u52c3"), SocialNetwork.createUser("Charlie", "\u67e5\u7406"), SocialNetwork.createUser("David", "\u5927\u536b"), SocialNetwork.createUser("Eve", "\u4f0a\u8299"), SocialNetwork.createUser("Frank", "\u5f17\u5170\u514b"));
        for (Node user : users) {
            network.graphDB.addNode(user);
        }
        network.addFriendship("Alice", "Bob");
        network.addFriendship("Alice", "Charlie");
        network.addFriendship("Bob", "David");
        network.addFriendship("Charlie", "David");
        network.addFriendship("Charlie", "Eve");
        network.addFriendship("Eve", "Frank");
        System.out.println("\u4e3a\u7231\u4e3d\u4e1d\u63a8\u8350\u7684\u597d\u53cb\uff1a");
        network.recommendFriends("Alice").forEach(System.out::println);
    }

    private static Node createUser(String id, String name) {
        Node user = new Node(id.toLowerCase());
        user.addLabel("User");
        user.setProperty("name", name);
        return user;
    }

    public void addFriendship(String user1, String user2) {
        Node node1 = this.graphDB.getNode(user1.toLowerCase());
        Node node2 = this.graphDB.getNode(user2.toLowerCase());
        if (node1 == null || node2 == null) {
            throw new IllegalArgumentException("\u5176\u4e2d\u4e00\u4e2a\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Relationship rel1 = new Relationship(UUID.randomUUID().toString(), node1.getId(), node2.getId(), "FRIEND");
        Relationship rel2 = new Relationship(UUID.randomUUID().toString(), node2.getId(), node1.getId(), "FRIEND");
        this.graphDB.addRelationship(rel1);
        this.graphDB.addRelationship(rel2);
    }

    public List<String> recommendFriends(String userId) {
        Node user = this.graphDB.getNode(userId.toLowerCase());
        if (user == null) {
            throw new IllegalArgumentException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Set friends = user.getOutgoingEdges().stream().filter(v -> v.getType().equals("FRIEND")).map(rel -> rel.getEndNodeId()).collect(Collectors.toSet());
        HashMap<String, Integer> friendOfFriends = new HashMap<String, Integer>();
        for (String friend : friends) {
            Node friendNode = this.graphDB.getNode(friend);
            for (Relationship rel2 : friendNode.getOutgoingEdges()) {
                String target = rel2.getEndNodeId();
                if (friends.contains(target) || target.equals(userId)) continue;
                friendOfFriends.put(target, friendOfFriends.getOrDefault(target, 0) + 1);
            }
        }
        ArrayList recommendations = new ArrayList(friendOfFriends.keySet());
        recommendations.sort((a, b) -> (Integer)friendOfFriends.get(b) - (Integer)friendOfFriends.get(a));
        return recommendations.stream().map(id -> (String)this.graphDB.getNode((String)id).getProperty("name")).collect(Collectors.toList());
    }
}

