/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.test;

import io.github.javpower.vectorex.keynote.graph.core.CypherQuery;
import io.github.javpower.vectorex.keynote.graph.core.GraphDB;
import io.github.javpower.vectorex.keynote.graph.entity.Node;
import io.github.javpower.vectorex.keynote.graph.entity.Relationship;
import java.util.UUID;

public class CypherQueryTest {
    public static void main(String[] args) {
        GraphDB db = new GraphDB("test.db");
        CypherQuery query = new CypherQuery(db);
        Node alice = new Node("Alice");
        alice.addLabel("Person");
        alice.setProperty("name", "\u7231\u4e3d\u4e1d");
        alice.setProperty("age", 25);
        Node bob = new Node("Bob");
        bob.addLabel("Person");
        bob.setProperty("name", "\u9c8d\u52c3");
        bob.setProperty("age", 30);
        Node charlie = new Node("Charlie");
        charlie.addLabel("Person");
        charlie.setProperty("name", "\u67e5\u7406");
        charlie.setProperty("age", 35);
        db.addNode(alice);
        db.addNode(bob);
        db.addNode(charlie);
        Relationship aliceBob = new Relationship(UUID.randomUUID().toString(), "Alice", "Bob", "FRIEND");
        Relationship bobCharlie = new Relationship(UUID.randomUUID().toString(), "Bob", "Charlie", "FRIEND");
        db.addRelationship(aliceBob);
        db.addRelationship(bobCharlie);
        System.out.println("\u67e5\u8be2\u8282\u70b9\uff1aMATCH (n:Person {name: '\u7231\u4e3d\u4e1d'}) RETURN n.name, n.age");
        query.execute("MATCH (n:Person {name: '\u7231\u4e3d\u4e1d'}) RETURN n.name, n.age").forEach(System.out::println);
        System.out.println("\n\u67e5\u8be2\u8def\u5f84\uff1aMATCH (a)-[*2]->(b) RETURN a.name, b.name");
        query.execute("MATCH (a)-[*2]->(b) RETURN a.name, b.name").forEach(System.out::println);
        System.out.println("\n\u805a\u5408\u67e5\u8be2\uff1aMATCH (n:Person) RETURN COUNT(*)");
        query.execute("MATCH (n:Person) RETURN COUNT(*)").forEach(System.out::println);
    }
}

