/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.core;

import io.github.javpower.vectorex.keynote.graph.core.GraphDB;
import io.github.javpower.vectorex.keynote.graph.entity.Node;
import io.github.javpower.vectorex.keynote.graph.entity.Relationship;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class CypherQuery {
    private final GraphDB graphDB;

    public CypherQuery(GraphDB graphDB) {
        this.graphDB = graphDB;
    }

    public List<Object> execute(String query) {
        String[] parts = query.split(" ", 2);
        List<Object> results = new ArrayList<Object>();
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid query format");
        }
        if (parts[0].equalsIgnoreCase("MATCH")) {
            if (parts[1].contains("(") && parts[1].contains(")")) {
                results.addAll(this.matchNodes(parts[1]));
            } else if (parts[1].contains("-[")) {
                results.addAll(this.matchPaths(parts[1]));
            }
        }
        if (query.contains("RETURN")) {
            String returnPart = query.substring(query.indexOf("RETURN") + 6).trim();
            results = this.processReturn(results, returnPart);
        }
        return results;
    }

    private List<Node> matchNodes(String pattern) {
        pattern = pattern.trim();
        pattern = pattern.substring(1, pattern.length() - 1);
        String[] parts = pattern.split(" ", 2);
        String label = "";
        String properties = "{}";
        if (parts.length > 1) {
            label = parts[0];
            properties = parts[1];
        } else {
            label = parts[0];
        }
        List<Node> nodes = this.graphDB.findNodesByLabel(label);
        if (properties.contains("{") && properties.contains("}")) {
            String[] props;
            properties = properties.substring(1, properties.length() - 1);
            for (String prop : props = properties.split(",")) {
                if (!(prop = prop.trim()).contains(":")) {
                    throw new IllegalArgumentException("Invalid property format: " + prop);
                }
                String[] keyValue = prop.split(":", 2);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException("Invalid property format: " + prop);
                }
                String key = keyValue[0].trim();
                String value = keyValue[1].trim().replaceAll("\"", "");
                nodes = nodes.stream().filter(node -> value.equals(node.getProperty(key))).collect(Collectors.toList());
            }
        }
        return nodes;
    }

    private List<List<Node>> matchPaths(String pattern) {
        pattern = pattern.trim();
        String[] parts = pattern.split("-");
        String startNode = parts[0].substring(1, parts[0].length() - 1);
        String endNode = parts[2].substring(1, parts[2].length() - 1);
        String relType = parts[1].substring(2, parts[1].length() - 1);
        ArrayList<List<Node>> paths = new ArrayList<List<Node>>();
        List<Relationship> relationships = this.graphDB.findRelationshipsByType(relType);
        for (Relationship rel : relationships) {
            if (!rel.getStartNodeId().equals(startNode) || !rel.getEndNodeId().equals(endNode)) continue;
            List<Node> path = Arrays.asList(this.graphDB.getNode(startNode), this.graphDB.getNode(endNode));
            paths.add(path);
        }
        return paths;
    }

    private List<Object> processReturn(List<Object> results, String returnPart) {
        ArrayList<Object> processedResults = new ArrayList<Object>();
        String[] returnFields = returnPart.split(",");
        for (Object result : results) {
            HashMap<String, Object> returnValues;
            if (result instanceof Node) {
                Node node2 = (Node)result;
                returnValues = new HashMap<String, Object>();
                for (String field : returnFields) {
                    if ((field = field.trim()).equals("COUNT(*)")) {
                        returnValues.put("COUNT(*)", results.size());
                        continue;
                    }
                    returnValues.put(field, node2.getProperty(field));
                }
                processedResults.add(returnValues);
                continue;
            }
            if (!(result instanceof List)) continue;
            List path = (List)result;
            returnValues = new HashMap();
            for (String field : returnFields) {
                if ((field = field.trim()).equals("COUNT(*)")) {
                    returnValues.put("COUNT(*)", results.size());
                    continue;
                }
                String finalField = field;
                returnValues.put(field, path.stream().map(node -> node.getProperty(finalField)).collect(Collectors.toList()));
            }
            processedResults.add(returnValues);
        }
        return processedResults;
    }
}

