/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.analysis;

import io.github.javpower.vectorex.keynote.analysis.CharacterUtil;
import io.github.javpower.vectorex.keynote.analysis.DictionaryManager;
import io.github.javpower.vectorex.keynote.analysis.FinalSegmenter;
import io.github.javpower.vectorex.keynote.analysis.SegToken;
import io.github.javpower.vectorex.keynote.analysis.SegmentationStrategy;
import java.util.ArrayList;
import java.util.List;

public class IndexSegmentationStrategy
implements SegmentationStrategy {
    private final DictionaryManager dictionary = DictionaryManager.getInstance();
    private final FinalSegmenter segmenter = FinalSegmenter.getInstance();

    @Override
    public List<SegToken> segment(String text) {
        ArrayList<SegToken> tokens = new ArrayList<SegToken>();
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = CharacterUtil.regularize(text.charAt(i));
            if (CharacterUtil.isChineseOrEnglishLetter(ch)) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) {
                this.processSegment(sb.toString(), offset, tokens);
                sb.setLength(0);
            }
            tokens.add(new SegToken(String.valueOf(ch), offset, offset + 1));
            ++offset;
        }
        if (sb.length() > 0) {
            this.processSegment(sb.toString(), offset, tokens);
        }
        return tokens;
    }

    private void processSegment(String segment, int offset, List<SegToken> tokens) {
        List<String> words = this.segmenter.cut(segment);
        for (String word : words) {
            tokens.add(new SegToken(word, offset, offset + word.length()));
            offset += word.length();
        }
    }
}

