/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.analysis;

import io.github.javpower.vectorex.keynote.analysis.TrieSegment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DictionaryManager {
    private static volatile DictionaryManager instance;
    private final Map<String, Double> wordFrequencies = new HashMap<String, Double>();
    private final Set<String> loadedPaths = new HashSet<String>();
    private final TrieSegment trie = new TrieSegment(Character.valueOf('\u0000'));

    private DictionaryManager() {
        this.loadMainDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DictionaryManager getInstance() {
        if (instance != null) return instance;
        Class<DictionaryManager> clazz = DictionaryManager.class;
        synchronized (DictionaryManager.class) {
            if (instance != null) return instance;
            instance = new DictionaryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadMainDictionary() {
        String mainDictPath = "/dict.txt";
        this.loadDictionary(mainDictPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserDictionary(String path) {
        if (this.loadedPaths.contains(path)) {
            return;
        }
        DictionaryManager dictionaryManager = this;
        synchronized (dictionaryManager) {
            if (this.loadedPaths.contains(path)) {
                return;
            }
            this.loadDictionary(path);
            this.loadedPaths.add(path);
        }
    }

    private void loadDictionary(String path) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path), Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split("[\t ]+");
                if (tokens.length < 1) continue;
                String word = tokens[0];
                double freq = tokens.length == 2 ? Double.parseDouble(tokens[1]) : 3.0;
                this.addWord(word, freq);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load dictionary: " + path);
        }
    }

    private void addWord(String word, double freq) {
        word = word.trim().toLowerCase();
        char[] chars = word.toCharArray();
        this.trie.fillSegment(chars, 0, chars.length, 1);
        this.wordFrequencies.put(word, Math.log(freq));
    }

    public boolean containsWord(String word) {
        return this.wordFrequencies.containsKey(word);
    }

    public double getFrequency(String word) {
        return this.wordFrequencies.getOrDefault(word, Double.NEGATIVE_INFINITY);
    }

    public TrieSegment getTrie() {
        return this.trie;
    }
}

