/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.util;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParsingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import nu.studer.java.util.OrderedProperties;
import pl.project13.core.CannotReadFileException;

public class JsonManager {
    protected static void dumpJson(OutputStream outputStream, OrderedProperties sortedLocalProperties, Charset sourceCharset) throws IOException {
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true));
        try (OutputStreamWriter outputWriter = new OutputStreamWriter(outputStream, sourceCharset);){
            JsonGenerator jg = jgf.createGenerator((Writer)outputWriter);
            jg.writeStartObject();
            for (Map.Entry e : sortedLocalProperties.entrySet()) {
                jg.write((String)e.getKey(), (String)e.getValue());
            }
            jg.writeEnd();
            jg.close();
        }
    }

    protected static Properties readJsonProperties(@Nonnull File jsonFile, Charset sourceCharset) throws CannotReadFileException {
        Properties retVal = new Properties();
        try (FileInputStream fis = new FileInputStream(jsonFile);
             InputStreamReader reader = new InputStreamReader((InputStream)fis, sourceCharset);
             JsonReader jsonReader = Json.createReader((Reader)reader);){
            jsonReader.readObject().forEach((key, val) -> {
                if (val instanceof JsonString) {
                    retVal.setProperty((String)key, ((JsonString)val).getString());
                }
            });
        }
        catch (JsonParsingException e) {
            throw new CannotReadFileException(e);
        }
        catch (IOException e) {
            throw new CannotReadFileException(e);
        }
        return retVal;
    }
}

