/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.joda.time.DateTime;
import org.sonatype.plexus.build.incremental.BuildContext;
import pl.project13.core.CommitIdGenerationMode;
import pl.project13.core.CommitIdPropertiesOutputFormat;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.GitCommitIdPlugin;
import pl.project13.core.PropertiesFileGenerator;
import pl.project13.core.git.GitDescribeConfig;
import pl.project13.core.log.LogInterface;
import pl.project13.core.util.BuildFileChangeListener;
import pl.project13.maven.git.PropertiesReplacer;
import pl.project13.maven.git.ReplacementProperty;

@Mojo(name="revision", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class GitCommitIdMojo
extends AbstractMojo {
    private static final String CONTEXT_KEY = GitCommitIdMojo.class.getName() + ".properties";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    MojoExecution mojoExecution;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    Settings settings;
    @Parameter(defaultValue="false")
    boolean injectAllReactorProjects;
    @Parameter(defaultValue="false")
    boolean verbose;
    @Parameter(defaultValue="true")
    boolean skipPoms;
    @Parameter(defaultValue="false")
    boolean generateGitPropertiesFile;
    @Parameter(defaultValue="${project.build.outputDirectory}/git.properties")
    String generateGitPropertiesFilename;
    @Parameter(defaultValue="true")
    boolean generateGitPropertiesFileWithEscapedUnicode;
    @Parameter(defaultValue="${project.basedir}/.git")
    File dotGitDirectory;
    @Parameter
    GitDescribeConfig gitDescribe;
    @Parameter(defaultValue="7")
    int abbrevLength;
    @Parameter(defaultValue="properties")
    String format;
    private CommitIdPropertiesOutputFormat commitIdPropertiesOutputFormat;
    @Parameter(defaultValue="git")
    String prefix;
    @Parameter(defaultValue="yyyy-MM-dd'T'HH:mm:ssXXX")
    String dateFormat;
    @Parameter
    String dateFormatTimeZone;
    @Parameter(defaultValue="true")
    boolean failOnNoGitDirectory;
    @Parameter(defaultValue="true")
    boolean failOnUnableToExtractRepoInfo;
    @Parameter(defaultValue="false")
    boolean useNativeGit;
    @Parameter(property="maven.gitcommitid.nativegit", defaultValue="false")
    boolean useNativeGitViaCommandLine;
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter(property="maven.gitcommitid.skip", defaultValue="false")
    private boolean skipViaCommandLine;
    @Parameter(defaultValue="false")
    boolean runOnlyOnce;
    @Parameter
    List<String> excludeProperties;
    @Parameter
    List<String> includeOnlyProperties;
    @Parameter(defaultValue="flat")
    String commitIdGenerationMode;
    private CommitIdGenerationMode commitIdGenerationModeEnum;
    @Parameter
    List<ReplacementProperty> replacementProperties;
    @Parameter(defaultValue="HEAD")
    String evaluateOnCommit;
    @Parameter(defaultValue="30000")
    long nativeGitTimeoutInMs;
    @Parameter(defaultValue="true")
    boolean useBranchNameFromBuildEnvironment;
    @Parameter(defaultValue="true")
    boolean injectIntoSysProperties;
    @Parameter(defaultValue="true")
    boolean offline;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String projectBuildOutputTimestamp;
    @Component
    private BuildContext buildContext;
    private Charset sourceCharset = StandardCharsets.UTF_8;

    protected Map<String, String> getCustomSystemEnv() {
        return System.getenv();
    }

    public void execute() throws MojoExecutionException {
        final LogInterface log = new LogInterface(){

            public void debug(String msg) {
                if (GitCommitIdMojo.this.verbose) {
                    GitCommitIdMojo.this.getLog().debug((CharSequence)msg);
                }
            }

            public void info(String msg) {
                if (GitCommitIdMojo.this.verbose) {
                    GitCommitIdMojo.this.getLog().info((CharSequence)msg);
                }
            }

            public void warn(String msg) {
                if (GitCommitIdMojo.this.verbose) {
                    GitCommitIdMojo.this.getLog().warn((CharSequence)msg);
                }
            }

            public void error(String msg) {
                if (GitCommitIdMojo.this.verbose) {
                    GitCommitIdMojo.this.getLog().error((CharSequence)msg);
                }
            }

            public void error(String msg, Throwable t) {
                if (GitCommitIdMojo.this.verbose) {
                    GitCommitIdMojo.this.getLog().error((CharSequence)msg, t);
                }
            }
        };
        try {
            boolean alreadyInjected;
            if (this.buildContext != null && this.buildContext.isIncremental() && (!this.generateGitPropertiesFile || PropertiesFileGenerator.craftPropertiesOutputFile((File)this.project.getBasedir(), (File)new File(this.generateGitPropertiesFilename)).exists())) {
                return;
            }
            String sourceEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
            this.sourceCharset = null != sourceEncoding ? Charset.forName(sourceEncoding) : Charset.defaultCharset();
            if (this.skip || this.skipViaCommandLine) {
                log.info("skip is enabled, skipping execution!");
                return;
            }
            if (this.runOnlyOnce) {
                List sortedProjects = Optional.ofNullable(this.session.getProjectDependencyGraph()).map(graph -> graph.getSortedProjects()).orElseGet(() -> {
                    log.warn("Maven's dependency graph is null. Assuming project is the only one executed.");
                    return Collections.singletonList(this.session.getCurrentProject());
                });
                MavenProject firstProject = sortedProjects.stream().filter(p -> {
                    if (this.skipPoms) {
                        return !this.isPomProject((MavenProject)p);
                    }
                    return true;
                }).findFirst().orElse(this.session.getCurrentProject());
                log.info("Current project: '" + this.session.getCurrentProject().getName() + "', first project to execute based on dependency graph: '" + firstProject.getName() + "'");
                if (!this.session.getCurrentProject().equals((Object)firstProject)) {
                    log.info("runOnlyOnce is enabled and this project is not the first project (perhaps skipPoms is configured?), skipping execution!");
                    return;
                }
            }
            if (this.isPomProject(this.project) && this.skipPoms) {
                log.info("isPomProject is true and skipPoms is true, return");
                return;
            }
            if (this.gitDescribe == null) {
                this.gitDescribe = new GitDescribeConfig();
            }
            try {
                this.commitIdGenerationModeEnum = CommitIdGenerationMode.valueOf((String)this.commitIdGenerationMode.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                log.warn("Detected wrong setting for 'commitIdGenerationMode'. Falling back to default 'flat' mode!");
                this.commitIdGenerationModeEnum = CommitIdGenerationMode.FLAT;
            }
            try {
                this.commitIdPropertiesOutputFormat = CommitIdPropertiesOutputFormat.valueOf((String)this.format.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                log.warn("Detected wrong setting for 'format'. Falling back to default 'properties' mode!");
                this.commitIdPropertiesOutputFormat = CommitIdPropertiesOutputFormat.PROPERTIES;
            }
            Properties properties = null;
            final Properties contextProperties = this.getContextProperties(this.project);
            boolean bl = alreadyInjected = this.injectAllReactorProjects && contextProperties != null;
            if (alreadyInjected) {
                log.info("injectAllReactorProjects is enabled - attempting to use the already computed values");
                properties = new Properties(contextProperties);
            }
            GitCommitIdPlugin.Callback cb = new GitCommitIdPlugin.Callback(){

                public Map<String, String> getSystemEnv() {
                    return GitCommitIdMojo.this.getCustomSystemEnv();
                }

                public Supplier<String> supplyProjectVersion() {
                    return () -> GitCommitIdMojo.this.project.getVersion();
                }

                @Nonnull
                public LogInterface getLogInterface() {
                    return log;
                }

                @Nonnull
                public String getDateFormat() {
                    return GitCommitIdMojo.this.dateFormat;
                }

                @Nonnull
                public String getDateFormatTimeZone() {
                    return GitCommitIdMojo.this.dateFormatTimeZone;
                }

                @Nonnull
                public String getPrefixDot() {
                    String trimmedPrefix = GitCommitIdMojo.this.prefix.trim();
                    return trimmedPrefix.equals("") ? "" : trimmedPrefix + ".";
                }

                public List<String> getExcludeProperties() {
                    return GitCommitIdMojo.this.excludeProperties;
                }

                public List<String> getIncludeOnlyProperties() {
                    return GitCommitIdMojo.this.includeOnlyProperties;
                }

                @Nullable
                public Date getReproducibleBuildOutputTimestamp() throws GitCommitIdExecutionException {
                    return GitCommitIdMojo.parseOutputTimestamp(GitCommitIdMojo.this.projectBuildOutputTimestamp);
                }

                public boolean useNativeGit() {
                    return GitCommitIdMojo.this.useNativeGit || GitCommitIdMojo.this.useNativeGitViaCommandLine;
                }

                public long getNativeGitTimeoutInMs() {
                    return GitCommitIdMojo.this.nativeGitTimeoutInMs;
                }

                public int getAbbrevLength() {
                    return GitCommitIdMojo.this.abbrevLength;
                }

                public GitDescribeConfig getGitDescribe() {
                    return GitCommitIdMojo.this.gitDescribe;
                }

                public CommitIdGenerationMode getCommitIdGenerationMode() {
                    return GitCommitIdMojo.this.commitIdGenerationModeEnum;
                }

                public boolean getUseBranchNameFromBuildEnvironment() {
                    return GitCommitIdMojo.this.useBranchNameFromBuildEnvironment;
                }

                public boolean isOffline() {
                    return GitCommitIdMojo.this.offline || GitCommitIdMojo.this.settings.isOffline();
                }

                public String getEvaluateOnCommit() {
                    return GitCommitIdMojo.this.evaluateOnCommit;
                }

                public File getDotGitDirectory() {
                    return GitCommitIdMojo.this.dotGitDirectory;
                }

                public boolean shouldGenerateGitPropertiesFile() {
                    return GitCommitIdMojo.this.generateGitPropertiesFile;
                }

                public void performPublishToAllSystemEnvironments(Properties properties) {
                    GitCommitIdMojo.this.publishToAllSystemEnvironments(this.getLogInterface(), properties, contextProperties);
                }

                public void performPropertiesReplacement(Properties properties) {
                    PropertiesReplacer propertiesReplacer = new PropertiesReplacer(log, new PluginParameterExpressionEvaluator(GitCommitIdMojo.this.session, GitCommitIdMojo.this.mojoExecution));
                    propertiesReplacer.performReplacement(properties, GitCommitIdMojo.this.replacementProperties);
                    GitCommitIdMojo.this.logProperties(this.getLogInterface(), properties);
                }

                public CommitIdPropertiesOutputFormat getPropertiesOutputFormat() {
                    return GitCommitIdMojo.this.commitIdPropertiesOutputFormat;
                }

                public BuildFileChangeListener getBuildFileChangeListener() {
                    return file -> {
                        if (GitCommitIdMojo.this.buildContext != null) {
                            GitCommitIdMojo.this.buildContext.refresh(file);
                        }
                    };
                }

                public String getProjectName() {
                    return GitCommitIdMojo.this.project.getName();
                }

                public File getProjectBaseDir() {
                    return GitCommitIdMojo.this.project.getBasedir();
                }

                public File getGenerateGitPropertiesFile() {
                    return new File(GitCommitIdMojo.this.generateGitPropertiesFilename);
                }

                public Charset getPropertiesSourceCharset() {
                    return GitCommitIdMojo.this.sourceCharset;
                }

                public boolean shouldPropertiesEscapeUnicode() {
                    return GitCommitIdMojo.this.generateGitPropertiesFileWithEscapedUnicode;
                }

                public boolean shouldFailOnNoGitDirectory() {
                    return GitCommitIdMojo.this.failOnNoGitDirectory;
                }
            };
            GitCommitIdPlugin.runPlugin((GitCommitIdPlugin.Callback)cb, (Properties)properties);
        }
        catch (GitCommitIdExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void publishToAllSystemEnvironments(@Nonnull LogInterface log, @Nonnull Properties propertiesToPublish, @Nullable Properties contextProperties) {
        this.publishPropertiesInto(propertiesToPublish, this.project.getProperties());
        this.publishPropertiesInto(propertiesToPublish, this.session.getUserProperties());
        if (this.injectAllReactorProjects) {
            Properties diffPropertiesToPublish = new Properties();
            propertiesToPublish.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (contextProperties == null || !contextProperties.contains(k)) {
                    diffPropertiesToPublish.setProperty(k.toString(), v.toString());
                }
            }));
            if (!diffPropertiesToPublish.isEmpty()) {
                this.appendPropertiesToReactorProjects(log, diffPropertiesToPublish);
            }
        }
        if (this.injectIntoSysProperties) {
            this.publishPropertiesInto(propertiesToPublish, System.getProperties());
            this.publishPropertiesInto(propertiesToPublish, this.session.getSystemProperties());
            this.publishPropertiesInto(propertiesToPublish, this.session.getRequest().getSystemProperties());
        }
    }

    @Nullable
    private Properties getContextProperties(MavenProject project) {
        Object stored = project.getContextValue(CONTEXT_KEY);
        if (stored instanceof Properties) {
            return (Properties)stored;
        }
        return null;
    }

    @VisibleForTesting
    protected static Date parseOutputTimestamp(String outputTimestamp) {
        if (outputTimestamp != null && !outputTimestamp.trim().isEmpty() && outputTimestamp.chars().allMatch(Character::isDigit)) {
            return Date.from(Instant.ofEpochSecond(Long.parseLong(outputTimestamp)));
        }
        if (outputTimestamp == null || outputTimestamp.length() < 2) {
            return null;
        }
        return new DateTime((Object)outputTimestamp).toDate();
    }

    private void publishPropertiesInto(Properties propertiesToPublish, Properties propertiesTarget) {
        for (String propertyName : propertiesToPublish.stringPropertyNames()) {
            propertiesTarget.setProperty(propertyName, propertiesToPublish.getProperty(propertyName));
        }
    }

    private void appendPropertiesToReactorProjects(LogInterface log, Properties propertiesToPublish) {
        for (MavenProject mavenProject : this.reactorProjects) {
            log.debug("Adding properties to project: '" + mavenProject.getName() + "'");
            if (mavenProject.equals((Object)this.project)) continue;
            this.publishPropertiesInto(propertiesToPublish, mavenProject.getProperties());
            mavenProject.setContextValue(CONTEXT_KEY, (Object)propertiesToPublish);
        }
        log.info("Added properties to '" + this.reactorProjects.size() + "' projects");
    }

    private void logProperties(LogInterface log, Properties propertiesToPublish) {
        for (String propertyName : propertiesToPublish.stringPropertyNames()) {
            log.info("including property '" + propertyName + "' in results");
        }
    }

    private boolean isPomProject(@Nonnull MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }
}

