/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.Context;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WindowsPackager
extends Packager {
    private File manifestFile;
    private File msmFile;

    public File getManifestFile() {
        return this.manifestFile;
    }

    public File getMsmFile() {
        return this.msmFile;
    }

    public void setMsmFile(File msmFile) {
        this.msmFile = msmFile;
    }

    public WindowsPackager() {
        this.platform(Platform.windows);
    }

    @Override
    public void doInit() throws Exception {
        this.winConfig.setDefaults(this);
    }

    @Override
    protected void doCreateAppStructure() throws Exception {
        this.executableDestinationFolder = this.appFolder;
        this.jarFileDestinationFolder = this.appFolder;
        this.jreDestinationFolder = new File(this.appFolder, this.jreDirectoryName);
        this.resourcesDestinationFolder = this.appFolder;
    }

    @Override
    public File doCreateApp() throws Exception {
        Logger.infoIndent("Creating windows EXE ... with " + (Object)((Object)this.getWinConfig().getExeCreationTool()));
        this.manifestFile = new File(this.assetsFolder, this.name + ".exe.manifest");
        VelocityUtils.render("windows/exe.manifest.vtl", this.manifestFile, this);
        Logger.info("Exe manifest file generated in " + this.manifestFile.getAbsolutePath() + "!");
        this.executable = new File(this.appFolder, this.name + ".exe");
        if (this.classpath != null) {
            this.classpaths = Arrays.asList(this.classpath.split("[;:]"));
            if (!this.isUseResourcesAsWorkingDir()) {
                this.classpaths = this.classpaths.stream().map(cp -> new File((String)cp).isAbsolute() ? cp : "%EXEDIR%/" + cp).collect(Collectors.toList());
            }
            this.classpath = StringUtils.join((Iterable)this.classpaths, (String)";");
        }
        this.executable = Context.getContext().createWindowsExe(this);
        Logger.infoUnindent("Windows EXE file created in " + this.executable + "!");
        return this.appFolder;
    }
}

