/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.MacStartup;
import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VelocityUtils;
import io.github.fvarrui.javapackager.utils.VersionUtils;
import io.github.fvarrui.javapackager.utils.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

public class MacPackager
extends Packager {
    private File appFile;
    private File contentsFolder;
    private File resourcesFolder;
    private File javaFolder;
    private File macOSFolder;
    private File jreBundleFolder;

    public MacPackager() {
        this.platform(Platform.mac);
    }

    public File getAppFile() {
        return this.appFile;
    }

    @Override
    public void doInit() throws Exception {
        this.macConfig.setDefaults(this);
        if (!this.isUseResourcesAsWorkingDir()) {
            this.useResourcesAsWorkingDir = true;
            Logger.warn("'useResourcesAsWorkingDir' property disabled on Mac OS (useResourcesAsWorkingDir is always true)");
        }
    }

    @Override
    protected void doCreateAppStructure() throws Exception {
        this.appFile = new File(this.appFolder, this.name + ".app");
        this.contentsFolder = new File(this.appFile, "Contents");
        this.resourcesFolder = new File(this.contentsFolder, "Resources");
        this.javaFolder = new File(this.resourcesFolder, this.macConfig.isRelocateJar() ? "Java" : "");
        this.macOSFolder = new File(this.contentsFolder, "MacOS");
        FileUtils.mkdir(this.appFile);
        Logger.info("App file folder created: " + this.appFile.getAbsolutePath());
        FileUtils.mkdir(this.contentsFolder);
        Logger.info("Contents folder created: " + this.contentsFolder.getAbsolutePath());
        FileUtils.mkdir(this.resourcesFolder);
        Logger.info("Resources folder created: " + this.resourcesFolder.getAbsolutePath());
        FileUtils.mkdir(this.javaFolder);
        Logger.info("Java folder created: " + this.javaFolder.getAbsolutePath());
        FileUtils.mkdir(this.macOSFolder);
        Logger.info("MacOS folder created: " + this.macOSFolder.getAbsolutePath());
        this.executableDestinationFolder = this.macOSFolder;
        this.jarFileDestinationFolder = this.javaFolder;
        this.jreBundleFolder = new File(this.contentsFolder, "PlugIns/" + this.jreDirectoryName + ".jre");
        this.jreDestinationFolder = new File(this.jreBundleFolder, "Contents/Home");
        this.resourcesDestinationFolder = this.resourcesFolder;
    }

    @Override
    public File doCreateApp() throws Exception {
        if (this.bundleJre.booleanValue()) {
            this.processRuntimeInfoPlistFile();
        }
        FileUtils.copyFileToFolder(this.jarFile, this.javaFolder);
        this.processStartupScript();
        this.processClasspath();
        this.processInfoPlistFile();
        this.processProvisionProfileFile();
        this.codesign();
        this.notarize();
        return this.appFile;
    }

    private void processStartupScript() throws Exception {
        if (this.administratorRequired.booleanValue()) {
            this.executable = new File(this.macOSFolder, "startup");
            VelocityUtils.render("mac/startup.vtl", this.executable, this);
        } else {
            File launcher = this.macConfig.getCustomLauncher();
            if (launcher != null && launcher.canRead() && launcher.isFile()) {
                FileUtils.copyFileToFolder(launcher, this.macOSFolder);
                this.executable = new File(this.macOSFolder, launcher.getName());
            } else {
                this.executable = this.preparePrecompiledStartupStub();
            }
        }
        this.executable.setExecutable(true, false);
        Logger.info("Startup script file created in " + this.executable.getAbsolutePath());
    }

    private void processClasspath() {
        this.classpath = (this.macConfig.isRelocateJar() ? "Java/" : "") + this.jarFile.getName() + (this.classpath != null ? ":" + this.classpath : "");
        this.classpaths = Arrays.asList(this.classpath.split("[:;]"));
        if (!this.isUseResourcesAsWorkingDir()) {
            this.classpaths = this.classpaths.stream().map(cp -> new File((String)cp).isAbsolute() ? cp : "$ResourcesFolder/" + cp).collect(Collectors.toList());
        }
        this.classpath = StringUtils.join((Iterable)this.classpaths, (String)":");
    }

    private void processInfoPlistFile() throws Exception {
        File infoPlistFile = new File(this.contentsFolder, "Info.plist");
        if (this.macConfig.getCustomInfoPlist() != null && this.macConfig.getCustomInfoPlist().isFile() && this.macConfig.getCustomInfoPlist().canRead()) {
            FileUtils.copyFileToFile(this.macConfig.getCustomInfoPlist(), infoPlistFile);
        } else {
            VelocityUtils.render("mac/Info.plist.vtl", infoPlistFile, this);
            XMLUtils.prettify(infoPlistFile);
        }
        Logger.info("Info.plist file created in " + infoPlistFile.getAbsolutePath());
    }

    private void processRuntimeInfoPlistFile() throws Exception {
        File infoPlistFile = new File(this.jreBundleFolder, "Contents/Info.plist");
        if (this.macConfig.getCustomRuntimeInfoPlist() != null && this.macConfig.getCustomRuntimeInfoPlist().isFile() && this.macConfig.getCustomRuntimeInfoPlist().canRead()) {
            FileUtils.copyFileToFile(this.macConfig.getCustomRuntimeInfoPlist(), infoPlistFile);
        } else {
            VelocityUtils.render("mac/RuntimeInfo.plist.vtl", infoPlistFile, this);
            XMLUtils.prettify(infoPlistFile);
        }
        Logger.info("RuntimeInfo.plist file created in " + infoPlistFile.getAbsolutePath());
    }

    private void codesign() throws Exception {
        if (!Platform.mac.isCurrentPlatform()) {
            Logger.warn("Generated app could not be signed due to current platform is " + (Object)((Object)Platform.getCurrentPlatform()));
        } else if (!this.getMacConfig().isCodesignApp()) {
            Logger.warn("App codesigning disabled");
        } else {
            this.codesign(this.macConfig.getDeveloperId(), this.macConfig.getEntitlements(), this.appFile);
        }
    }

    private void notarize() throws Exception {
        if (!Platform.mac.isCurrentPlatform()) {
            Logger.warn("Generated app could not be notarized due to current platform is " + (Object)((Object)Platform.getCurrentPlatform()));
        } else if (!this.getMacConfig().isCodesignApp()) {
            Logger.warn("App codesigning disabled. Cannot notarize unsigned app");
        } else if (!this.getMacConfig().isNotarizeApp()) {
            Logger.warn("App notarization disabled");
        } else {
            this.notarize(this.macConfig.getKeyChainProfile(), this.appFile);
        }
    }

    private void processProvisionProfileFile() throws Exception {
        if (this.macConfig.getProvisionProfile() != null && this.macConfig.getProvisionProfile().isFile() && this.macConfig.getProvisionProfile().canRead()) {
            File provisionProfile = new File(this.contentsFolder, "embedded.provisionprofile");
            FileUtils.copyFileToFile(this.macConfig.getProvisionProfile(), provisionProfile);
            Logger.info("Provision profile file created from \n" + this.macConfig.getProvisionProfile() + " to \n" + provisionProfile.getAbsolutePath());
        }
    }

    private File preparePrecompiledStartupStub() throws Exception {
        File appStubFile = new File(this.macOSFolder, "universalJavaApplicationStub");
        String universalJavaApplicationStubResource = null;
        switch (this.macConfig.getMacStartup()) {
            case UNIVERSAL: {
                universalJavaApplicationStubResource = "universalJavaApplicationStub";
                break;
            }
            case X86_64: {
                universalJavaApplicationStubResource = "universalJavaApplicationStub.x86_64";
                break;
            }
            case ARM64: {
                universalJavaApplicationStubResource = "universalJavaApplicationStub.arm64";
                break;
            }
            case SCRIPT: {
                universalJavaApplicationStubResource = "universalJavaApplicationStub.sh";
            }
        }
        FileUtils.copyResourceToFile("/mac/" + universalJavaApplicationStubResource, appStubFile, this.macConfig.getMacStartup() == MacStartup.SCRIPT);
        return appStubFile;
    }

    private void codesign(String developerId, File entitlements, File appFile) throws Exception {
        entitlements = this.prepareEntitlementFile(entitlements);
        this.signAppBundle(appFile, developerId, entitlements);
    }

    private File prepareEntitlementFile(File entitlements) throws Exception {
        if (entitlements == null) {
            Logger.warn("Entitlements file not specified. Using defaults!");
            entitlements = new File(this.assetsFolder, "entitlements.plist");
            VelocityUtils.render("mac/entitlements.plist.vtl", entitlements, this);
        } else if (!entitlements.exists()) {
            throw new Exception("Entitlements file doesn't exist: " + entitlements);
        }
        return entitlements;
    }

    private void signAppBundle(File appFolder, String developerCertificateName, File entitlements) throws IOException, CommandLineException {
        try (Stream<Path> stream = Files.walk(appFolder.toPath(), new FileVisitOption[0]);){
            stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && (Files.isExecutable(p) || p.toString().endsWith(".dylib")) && !p.toString().contains("dylib.dSYM/Contents") && !p.equals(this.executable.toPath())).forEach(p -> {
                if (Files.isSymbolicLink(p)) {
                    Logger.debug("Skipping signing symlink: " + p);
                } else {
                    try {
                        this.codesign(Files.isExecutable(p) ? entitlements : null, developerCertificateName, p.toFile());
                    }
                    catch (IOException | CommandLineException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        if (this.bundleJre.booleanValue()) {
            this.codesign(developerCertificateName, this.jreBundleFolder);
        }
        this.codesign(entitlements, developerCertificateName, this.executable);
        this.codesign(entitlements, developerCertificateName, appFolder);
    }

    private void codesign(String developerCertificateName, File file) throws IOException, CommandLineException {
        this.codesign(null, developerCertificateName, file);
    }

    private void codesign(File entitlements, String developerCertificateName, File file) throws IOException, CommandLineException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add("-f");
        if (entitlements != null) {
            this.addHardenedCodesign(arguments);
            arguments.add("--entitlements");
            arguments.add(entitlements);
        }
        arguments.add("--timestamp");
        arguments.add("-s");
        arguments.add(developerCertificateName);
        arguments.add(file);
        CommandUtils.execute("codesign", arguments);
    }

    private void addHardenedCodesign(Collection<Object> args) {
        if (this.macConfig.isHardenedCodesign()) {
            if (VersionUtils.compareVersions("10.13.6", SystemUtils.OS_VERSION) >= 0) {
                args.add("-o");
                args.add("runtime");
            } else {
                Logger.warn("Mac OS version detected: " + SystemUtils.OS_VERSION + " ... hardened runtime disabled!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notarize(String keyChainProfile, File appFile) throws IOException, CommandLineException {
        Path zippedApp = null;
        try {
            zippedApp = this.zipApp(appFile);
            ArrayList<Object> notarizeArgs = new ArrayList<Object>();
            notarizeArgs.add("notarytool");
            notarizeArgs.add("submit");
            notarizeArgs.add(zippedApp.toString());
            notarizeArgs.add("--wait");
            notarizeArgs.add("--keychain-profile");
            notarizeArgs.add(keyChainProfile);
            CommandUtils.execute("xcrun", notarizeArgs);
        }
        finally {
            if (zippedApp != null) {
                Files.deleteIfExists(zippedApp);
            }
        }
        ArrayList<Object> stapleArgs = new ArrayList<Object>();
        stapleArgs.add("stapler");
        stapleArgs.add("staple");
        stapleArgs.add(appFile);
        CommandUtils.execute("xcrun", stapleArgs);
    }

    private Path zipApp(File appFile) throws IOException {
        Path zipPath = this.assetsFolder.toPath().resolve(appFile.getName() + "-notarization.zip");
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));){
            final Path sourcePath = appFile.toPath();
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(sourcePath.getParent().relativize(file).toString()));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return zipPath;
    }
}

