/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.model.Platform;
import io.github.fvarrui.javapackager.packagers.ArtifactGenerator;
import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.CommandUtils;
import io.github.fvarrui.javapackager.utils.FileUtils;
import io.github.fvarrui.javapackager.utils.JDKUtils;
import io.github.fvarrui.javapackager.utils.Logger;
import io.github.fvarrui.javapackager.utils.VersionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class BundleJre
extends ArtifactGenerator<Packager> {
    public BundleJre() {
        super("JRE");
    }

    @Override
    public boolean skip(Packager packager) {
        return packager.getBundleJre() == false;
    }

    @Override
    protected File doApply(Packager packager) throws Exception {
        File manFolder;
        boolean bundleJre = packager.getBundleJre();
        File specificJreFolder = packager.getJrePath();
        Platform platform = packager.getPlatform();
        File destinationFolder = packager.getJreDestinationFolder();
        File jdkPath = packager.getJdkPath();
        File libsFolder = packager.getLibsFolder();
        boolean customizedJre = packager.getCustomizedJre();
        File jarFile = packager.getJarFile();
        List<String> requiredModules = packager.getModules();
        List<String> additionalModules = packager.getAdditionalModules();
        List<File> additionalModulePaths = packager.getAdditionalModulePaths();
        File currentJdk = packager.getPackagingJdk();
        Logger.infoIndent("Bundling JRE ... with " + currentJdk);
        if (specificJreFolder != null) {
            Logger.info("Embedding JRE from " + specificJreFolder);
            if (!specificJreFolder.isDirectory()) {
                throw new Exception("'" + specificJreFolder + "' is not a directory!");
            }
            if (!JDKUtils.isValidJRE(platform, specificJreFolder)) {
                File fixedJreFolder;
                Logger.warn("An invalid JRE may have been specified for '" + (Object)((Object)platform) + "' platform: " + specificJreFolder + " ('release' file not found)");
                if (platform.equals((Object)Platform.mac) && JDKUtils.isValidJRE(platform, fixedJreFolder = new File(specificJreFolder, "Contents/Home"))) {
                    specificJreFolder = fixedJreFolder;
                    Logger.warn("Specified 'jrePath' fixed: " + specificJreFolder);
                }
            }
            if (destinationFolder.exists()) {
                FileUtils.removeFolder(destinationFolder);
            }
            FileUtils.copyFolderContentToFolder(specificJreFolder, destinationFolder);
            File binFolder = new File(destinationFolder, "bin");
            Arrays.asList(binFolder.listFiles()).forEach(f -> f.setExecutable(true, false));
            File libFolder = new File(destinationFolder, "lib");
            File jshFile = new File(libFolder, "jspawnhelper");
            if (jshFile.exists()) {
                jshFile.setExecutable(true, false);
            }
        } else {
            if (VersionUtils.getJavaMajorVersion() <= 8) {
                throw new Exception("Could not create a customized JRE due to JDK version is " + SystemUtils.JAVA_VERSION + ". Must use jrePath property to specify JRE location to be embedded");
            }
            if (!platform.isCurrentPlatform() && jdkPath.equals(currentJdk)) {
                Logger.warn("Cannot create a customized JRE ... target platform (" + (Object)((Object)platform) + ") is different than execution platform (" + (Object)((Object)Platform.getCurrentPlatform()) + "). Use 'jdkPath' property.");
                bundleJre = false;
            } else {
                Logger.info("Creating customized JRE ...");
                if (!JDKUtils.isValidJDK(platform, jdkPath)) {
                    throw new Exception("Invalid JDK for platform '" + (Object)((Object)platform) + "': " + jdkPath);
                }
                String modules = this.getRequiredModules(currentJdk, libsFolder, customizedJre, jarFile, requiredModules, additionalModules, additionalModulePaths);
                Logger.info("Creating JRE with next modules included: " + modules);
                File modulesDir = new File(jdkPath, "jmods");
                if (!modulesDir.exists()) {
                    throw new Exception("jmods folder doesn't exist: " + modulesDir);
                }
                Logger.info("Using " + modulesDir + " modules directory");
                if (destinationFolder.exists()) {
                    FileUtils.removeFolder(destinationFolder);
                }
                File jlink = new File(currentJdk, "/bin/jlink");
                CommandUtils.execute(jlink, "--module-path", modulesDir, this.additionalModulePathsToParams(additionalModulePaths), "--add-modules", modules, "--output", destinationFolder, "--no-header-files", "--no-man-pages", "--strip-debug", "--compress=2");
                File binFolder = new File(destinationFolder, "bin");
                Arrays.asList(binFolder.listFiles()).forEach(f -> f.setExecutable(true, false));
            }
        }
        File legalFolder = new File(destinationFolder, "legal");
        if (legalFolder.exists()) {
            FileUtils.removeFolder(legalFolder);
        }
        if ((manFolder = new File(destinationFolder, "man")).exists()) {
            FileUtils.removeFolder(manFolder);
        }
        if (bundleJre) {
            Logger.infoUnindent("JRE bundled in " + destinationFolder.getAbsolutePath() + "!");
        } else {
            Logger.infoUnindent("JRE bundling skipped!");
        }
        packager.bundleJre(bundleJre);
        return destinationFolder;
    }

    protected String getRequiredModules(File packagingJdk, File libsFolder, boolean customizedJre, File jarFile, List<String> defaultModules, List<String> additionalModules, List<File> additionalModulePaths) throws Exception {
        List<String> modulesList;
        Logger.infoIndent("Getting required modules ... ");
        File jdeps = new File(packagingJdk, "/bin/jdeps");
        File jarLibs = null;
        if (libsFolder != null && libsFolder.exists()) {
            jarLibs = new File(libsFolder, "*.jar");
        } else {
            Logger.warn("No dependencies found!");
        }
        if (customizedJre && defaultModules != null && !defaultModules.isEmpty()) {
            modulesList = defaultModules.stream().map(module -> module.trim()).collect(Collectors.toList());
        } else if (customizedJre && VersionUtils.getJavaMajorVersion() >= 13) {
            String modules = CommandUtils.execute(jdeps.getAbsolutePath(), "-q", "--multi-release", VersionUtils.getJavaMajorVersion(), "--ignore-missing-deps", "--print-module-deps", this.additionalModulePathsToParams(additionalModulePaths), jarLibs, jarFile);
            modulesList = Arrays.asList(modules.split(",")).stream().map(module -> module.trim()).filter(module -> !module.isEmpty()).collect(Collectors.toList());
        } else if (customizedJre && VersionUtils.getJavaMajorVersion() >= 9) {
            String modules = CommandUtils.execute(jdeps.getAbsolutePath(), "-q", "--multi-release", VersionUtils.getJavaMajorVersion(), "--ignore-missing-deps", "--list-deps", this.additionalModulePathsToParams(additionalModulePaths), jarLibs, jarFile);
            modulesList = Arrays.asList(modules.split("\n")).stream().map(module -> module.trim()).map(module -> module.contains("/") ? module.split("/")[0] : module).filter(module -> !module.isEmpty()).filter(module -> !module.startsWith("JDK removed internal")).distinct().collect(Collectors.toList());
        } else {
            modulesList = new ArrayList<String>();
        }
        if (modulesList.isEmpty()) {
            Logger.warn("It was not possible to determine the necessary modules. All modules will be included");
            modulesList.add("ALL-MODULE-PATH");
        } else {
            modulesList.addAll(additionalModules);
        }
        Logger.infoUnindent("Required modules found: " + modulesList);
        return StringUtils.join(modulesList, (String)",");
    }

    private String[] additionalModulePathsToParams(List<File> additionalModulePaths) {
        ArrayList additionalPaths = new ArrayList();
        additionalModulePaths.stream().filter(path -> {
            if (path.exists()) {
                return true;
            }
            Logger.warn("Additional module path not found: " + path);
            return false;
        }).forEach(path -> {
            additionalPaths.add("--module-path");
            additionalPaths.add(path.toString());
        });
        return additionalPaths.toArray(new String[0]);
    }
}

