/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.packagers;

import io.github.fvarrui.javapackager.packagers.Packager;
import io.github.fvarrui.javapackager.utils.Logger;
import java.io.File;

public abstract class ArtifactGenerator<T extends Packager> {
    private String artifactName;

    public ArtifactGenerator() {
    }

    public ArtifactGenerator(String artifactName) {
        this.artifactName = artifactName;
    }

    public boolean skip(T packager) {
        return false;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    protected abstract File doApply(T var1) throws Exception;

    public File apply(Packager packager) throws Exception {
        if (this.skip(packager)) {
            Logger.warn(this.getArtifactName() + " artifact generation skipped!");
            return null;
        }
        return this.doApply(packager);
    }
}

