/*
 * Decompiled with CFR 0.152.
 */
package io.github.fvarrui.javapackager.gradle;

import io.github.fvarrui.javapackager.packagers.Packager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;

public abstract class AbstractPackageTask
extends DefaultTask {
    private List<File> outputFiles;

    @OutputFiles
    public List<File> getOutputFiles() {
        return this.outputFiles != null ? this.outputFiles : new ArrayList<File>();
    }

    public AbstractPackageTask() {
        this.setGroup("JavaPackager");
        this.setDescription("Packages the application as a native Windows, MacOS or GNU/Linux executable and creates an installer");
        this.getOutputs().upToDateWhen(o -> false);
    }

    @TaskAction
    public void doPackage() throws Exception {
        Packager packager = this.createPackager();
        File app = packager.createApp();
        List<File> installers = packager.generateInstallers();
        List<File> bundles = packager.createBundles();
        this.outputFiles = new ArrayList<File>();
        this.outputFiles.add(app);
        this.outputFiles.addAll(installers);
        this.outputFiles.addAll(bundles);
    }

    protected abstract Packager createPackager() throws Exception;
}

