/*
 * Decompiled with CFR 0.152.
 */
package com.github.freakchick.orange.token;

import com.github.freakchick.orange.token.TokenHandler;
import org.dom4j.DocumentException;

public class TokenParser {
    private String openToken;
    private String closeToken;
    TokenHandler tokenHandler;

    public TokenParser(String openToken, String closeToken, TokenHandler tokenHandler) {
        this.openToken = openToken;
        this.closeToken = closeToken;
        this.tokenHandler = tokenHandler;
    }

    public static void main(String[] args) throws DocumentException {
    }

    public String parse(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int start = text.indexOf(this.openToken);
        if (start == -1) {
            return text;
        }
        char[] src = text.toCharArray();
        int offset = 0;
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        do {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(this.openToken);
                offset = start + this.openToken.length();
                continue;
            }
            if (expression == null) {
                expression = new StringBuilder();
            } else {
                expression.setLength(0);
            }
            builder.append(src, offset, start - offset);
            offset = start + this.openToken.length();
            int end = text.indexOf(this.closeToken, offset);
            while (end > -1) {
                if (end > offset && src[end - 1] == '\\') {
                    expression.append(src, offset, end - offset - 1).append(this.closeToken);
                    offset = end + this.closeToken.length();
                    end = text.indexOf(this.closeToken, offset);
                    continue;
                }
                expression.append(src, offset, end - offset);
                break;
            }
            if (end == -1) {
                builder.append(src, start, src.length - start);
                offset = src.length;
                continue;
            }
            builder.append(this.tokenHandler.handleToken(expression.toString().trim()));
            offset = end + this.closeToken.length();
        } while ((start = text.indexOf(this.openToken, offset)) > -1);
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }
}

