/*
 * Decompiled with CFR 0.152.
 */
package com.github.freakchick.orange.tag;

import com.github.freakchick.orange.node.MixedSqlNode;
import com.github.freakchick.orange.node.SqlNode;
import com.github.freakchick.orange.node.TextSqlNode;
import com.github.freakchick.orange.tag.ForeachHandler;
import com.github.freakchick.orange.tag.IfHandler;
import com.github.freakchick.orange.tag.SetHandler;
import com.github.freakchick.orange.tag.TagHandler;
import com.github.freakchick.orange.tag.TrimHandler;
import com.github.freakchick.orange.tag.WhereHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Text;

public class XmlParser {
    static Map<String, TagHandler> nodeHandlers = new HashMap<String, TagHandler>(){
        {
            this.put("foreach", new ForeachHandler());
            this.put("if", new IfHandler());
            this.put("trim", new TrimHandler());
            this.put("where", new WhereHandler());
            this.put("set", new SetHandler());
        }
    };

    public static SqlNode parseXml2SqlNode(String text) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)text);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage());
        }
        Element rootElement = document.getRootElement();
        List<SqlNode> contents = XmlParser.parseElement(rootElement);
        MixedSqlNode sqlNode = new MixedSqlNode(contents);
        return sqlNode;
    }

    public static List<SqlNode> parseElement(Element element) {
        ArrayList<SqlNode> nodes = new ArrayList<SqlNode>();
        List children = element.content();
        for (Object node : children) {
            if (node instanceof Text) {
                TextSqlNode textSqlNode = new TextSqlNode(((Text)node).getText());
                nodes.add(textSqlNode);
                continue;
            }
            if (!(node instanceof Element)) continue;
            String nodeName = ((Element)node).getName();
            TagHandler handler = nodeHandlers.get(nodeName.toLowerCase());
            if (handler == null) {
                throw new RuntimeException("tag not supported");
            }
            handler.handle((Element)node, nodes);
        }
        return nodes;
    }

    public static void main(String[] args) {
        XmlParser.parseXml2SqlNode("<a>111<if test='true'>222<if test='true'>333</if>444<foreach collection='list' open='(' close=')' separator=',' item='item'>fff</foreach></if>555</a>");
    }
}

