/*
 * Decompiled with CFR 0.152.
 */
package com.github.freakchick.orange.node;

import com.github.freakchick.orange.context.Context;
import com.github.freakchick.orange.node.SqlNode;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TrimSqlNode
implements SqlNode {
    SqlNode contents;
    String prefix;
    String suffix;
    List<String> prefixesToOverride;
    List<String> suffixesToOverride;

    public TrimSqlNode(SqlNode contents, String prefix, String suffix, List<String> prefixesToOverride, List<String> suffixesToOverride) {
        this.contents = contents;
        this.prefix = prefix;
        this.suffix = suffix;
        this.prefixesToOverride = prefixesToOverride;
        this.suffixesToOverride = suffixesToOverride;
    }

    @Override
    public void apply(Context context) {
        context.appendSql(" ");
        Context proxy = new Context(context.getData());
        this.contents.apply(proxy);
        String sql = proxy.getSql().trim();
        if (sql.length() > 0) {
            if (this.prefixesToOverride != null) {
                for (String key : this.prefixesToOverride) {
                    if (!sql.startsWith(key)) continue;
                    sql = sql.substring(key.length());
                }
            }
            if (this.suffixesToOverride != null) {
                for (String key : this.suffixesToOverride) {
                    if (!sql.endsWith(key)) continue;
                    sql = sql.substring(0, sql.length() - key.length());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sql) && StringUtils.isNotBlank((CharSequence)this.prefix)) {
            context.appendSql(this.prefix);
        }
        context.appendSql(sql);
        if (StringUtils.isNotBlank((CharSequence)sql) && StringUtils.isNotBlank((CharSequence)this.suffix)) {
            context.appendSql(this.suffix);
        }
    }

    @Override
    public void applyParameter(Set<String> set) {
        this.contents.applyParameter(set);
    }
}

