/*
 * Decompiled with CFR 0.152.
 */
package com.github.freakchick.orange.node;

import com.github.freakchick.orange.context.Context;
import com.github.freakchick.orange.node.SqlNode;
import com.github.freakchick.orange.token.TokenHandler;
import com.github.freakchick.orange.token.TokenParser;
import com.github.freakchick.orange.util.OgnlUtil;
import com.github.freakchick.orange.util.RegexUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ForeachSqlNode
implements SqlNode {
    String collection;
    String open;
    String close;
    String separator;
    String item;
    String index;
    SqlNode contents;
    String indexDataName;

    public ForeachSqlNode(String collection, String open, String close, String separator, String item, String index, SqlNode contents) {
        this.collection = collection;
        this.open = open;
        this.close = close;
        this.separator = separator;
        this.item = item;
        this.index = index;
        this.contents = contents;
        this.indexDataName = String.format("__index_%s", collection);
    }

    @Override
    public void apply(Context context) {
        context.appendSql(" ");
        Iterable<?> iterable = OgnlUtil.getIterable(this.collection, context.getData());
        int currentIndex = 0;
        ArrayList indexs = new ArrayList();
        context.getData().put(this.indexDataName, indexs);
        context.appendSql(this.open);
        for (Object o : iterable) {
            ((ArrayList)context.getData().get(this.indexDataName)).add(currentIndex);
            if (currentIndex != 0) {
                context.appendSql(this.separator);
            }
            Context proxy = new Context(context.getData());
            String childSqlText = this.getChildText(proxy, currentIndex);
            context.appendSql(childSqlText);
            ++currentIndex;
        }
        context.appendSql(this.close);
    }

    @Override
    public void applyParameter(Set<String> set) {
        set.add(this.collection);
        HashSet temp = new HashSet();
        this.contents.applyParameter(set);
        for (String key : temp) {
            if (key.matches(this.item + "[.,:\\s\\[]") || key.matches(this.index + "[.,:\\s\\[]")) continue;
            set.add(key);
        }
    }

    public String getChildText(Context proxy, int currentIndex) {
        final String newItem = String.format("%s[%d]", this.collection, currentIndex);
        final String newIndex = String.format("%s[%d]", this.indexDataName, currentIndex);
        this.contents.apply(proxy);
        String sql = proxy.getSql();
        TokenParser tokenParser = new TokenParser("#{", "}", new TokenHandler(){

            @Override
            public String handleToken(String content) {
                String replace = RegexUtil.replace(content, ForeachSqlNode.this.item, newItem);
                if (replace.equals(content)) {
                    replace = RegexUtil.replace(content, ForeachSqlNode.this.index, newIndex);
                }
                StringBuilder builder = new StringBuilder();
                return builder.append("#{").append(replace).append("}").toString();
            }
        });
        String parse = tokenParser.parse(sql);
        return parse;
    }
}

