/*
 * Decompiled with CFR 0.152.
 */
package com.github.freakchick.orange.engine;

import com.github.freakchick.orange.SqlMeta;
import com.github.freakchick.orange.context.Context;
import com.github.freakchick.orange.engine.Cache;
import com.github.freakchick.orange.node.SqlNode;
import com.github.freakchick.orange.tag.XmlParser;
import com.github.freakchick.orange.token.TokenHandler;
import com.github.freakchick.orange.token.TokenParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DynamicSqlEngine {
    Cache cache = new Cache();

    public SqlMeta parse(String text, Map<String, Object> params) {
        text = String.format("<root>%s</root>", text);
        SqlNode sqlNode = this.parseXml2SqlNode(text);
        Context context = new Context(params);
        this.parseSqlText(sqlNode, context);
        this.parseParameter(context);
        SqlMeta sqlMeta = new SqlMeta(context.getSql(), context.getJdbcParameters());
        return sqlMeta;
    }

    public Set<String> parseParameter(String text) {
        text = String.format("<root>%s</root>", text);
        SqlNode sqlNode = this.parseXml2SqlNode(text);
        HashSet<String> set = new HashSet<String>();
        sqlNode.applyParameter(set);
        return set;
    }

    private SqlNode parseXml2SqlNode(String text) {
        SqlNode node = this.cache.getNodeCache().get(text);
        if (node == null) {
            node = XmlParser.parseXml2SqlNode(text);
            this.cache.getNodeCache().put(text, node);
        }
        return node;
    }

    private void parseSqlText(SqlNode sqlNode, Context context) {
        sqlNode.apply(context);
    }

    private void parseParameter(final Context context) {
        TokenParser tokenParser = new TokenParser("#{", "}", new TokenHandler(){

            @Override
            public String handleToken(String content) {
                Object value = context.getOgnlValue(content);
                if (value == null) {
                    throw new RuntimeException("could not found value : " + content);
                }
                context.addParameter(value);
                return "?";
            }
        });
        String sql = tokenParser.parse(context.getSql());
        context.setSql(sql);
    }

    public static void main(String[] args) {
        DynamicSqlEngine engine = new DynamicSqlEngine();
        String sql = "<root>select <if test='minId != null'>id > ${minId} #{minId} <if test='maxId != null'> and id &lt; ${maxId} #{maxId}</if> </if></root>";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("minId", 100);
        map.put("maxId", 500);
        engine.parse(sql, map);
    }
}

