/*
 * Decompiled with CFR 0.152.
 */
package com.github.freakchick.orange.context;

import com.github.freakchick.orange.util.OgnlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Context {
    StringBuilder sqlBuilder = new StringBuilder();
    List<Object> jdbcParameters = new ArrayList<Object>();
    Set<String> paramNames = new HashSet<String>();
    Map<String, Object> data;

    public Context(Map<String, Object> data) {
        this.data = data;
    }

    public void appendSql(String text) {
        if (text != null) {
            this.sqlBuilder.append(text);
        }
    }

    public void addParameter(Object o) {
        this.jdbcParameters.add(o);
    }

    public void addParameterName(String o) {
        this.paramNames.add(o);
    }

    public Object getOgnlValue(String expression) {
        return OgnlUtil.getValue(expression, this.data);
    }

    public Boolean getOgnlBooleanValue(String expression) {
        return OgnlUtil.getBooleanValue(expression, this.data);
    }

    public String getSql() {
        return this.sqlBuilder.toString();
    }

    public void setSql(String text) {
        this.sqlBuilder = new StringBuilder(text);
    }

    public List<Object> getJdbcParameters() {
        return this.jdbcParameters;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

