/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree;

import java.util.ArrayList;

public class IndexTreePath<E> {
    private IndexTreePath<E> parentPath;
    private final E entry;
    private final int index;

    public IndexTreePath(IndexTreePath<E> parent, E entry, int index) {
        if (entry == null) {
            throw new IllegalArgumentException("entry in TreePath must be non null.");
        }
        this.entry = entry;
        this.index = index;
        this.parentPath = parent;
    }

    public E getEntry() {
        return this.entry;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPathCount() {
        int result = 0;
        IndexTreePath<E> path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTreePath<E> other = (IndexTreePath<E>)o;
        IndexTreePath<E> path = this;
        while (path != null) {
            if (other == null || path.index != other.index || !path.entry.equals(other.entry)) {
                return false;
            }
            other = other.parentPath;
            path = path.parentPath;
        }
        return true;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public IndexTreePath<E> getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200).append('[');
        ArrayList<String> c = new ArrayList<String>();
        for (IndexTreePath<E> p = this; p != null; p = p.getParentPath()) {
            c.add("@" + p.index + ":" + this.entry.toString());
        }
        for (int counter = c.size() - 1; counter >= 0; --counter) {
            buffer.append((String)c.get(counter)).append(counter > 0 ? ", " : "");
        }
        return buffer.append(']').toString();
    }
}

