/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree;

import elki.index.Index;
import elki.index.tree.DirectoryEntry;
import elki.index.tree.IndexTreePath;
import elki.index.tree.Node;
import elki.index.tree.TreeIndexHeader;
import elki.logging.Logging;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.persistent.PageFile;
import elki.persistent.PageHeader;

public abstract class IndexTree<N extends Node<E>, E>
implements Index {
    private final PageFile<N> file;
    protected boolean initialized = false;
    protected int dirCapacity;
    protected int leafCapacity;
    protected int dirMinimum;
    protected int leafMinimum;
    private E rootEntry;

    public IndexTree(PageFile<N> pagefile) {
        this.file = pagefile;
    }

    public void initialize() {
        TreeIndexHeader header = this.createHeader();
        if (this.file.initialize((PageHeader)header)) {
            this.initializeFromFile(header, this.file);
        }
        this.rootEntry = this.createRootEntry();
    }

    protected abstract Logging getLogger();

    public final E getRootEntry() {
        return this.rootEntry;
    }

    public final int getRootID() {
        return this.getPageID(this.rootEntry);
    }

    protected boolean isRoot(N page) {
        return this.getRootID() == page.getPageID();
    }

    protected int getPageID(E entry) {
        if (!(entry instanceof DirectoryEntry)) {
            throw new IllegalStateException("Leafs do not have page ids!");
        }
        return ((DirectoryEntry)entry).getPageID();
    }

    public N getNode(int nodeID) {
        return (N)((Node)this.file.readPage(nodeID));
    }

    public N getNode(E entry) {
        return this.getNode((E)this.getPageID(entry));
    }

    protected void writeNode(N node) {
        this.file.writePage(node);
    }

    protected void deleteNode(N node) {
        this.file.deletePage(node.getPageID());
    }

    protected TreeIndexHeader createHeader() {
        return new TreeIndexHeader(this.file.getPageSize(), this.dirCapacity, this.leafCapacity, this.dirMinimum, this.leafMinimum);
    }

    public void initializeFromFile(TreeIndexHeader header, PageFile<N> file) {
        this.dirCapacity = header.getDirCapacity();
        this.leafCapacity = header.getLeafCapacity();
        this.dirMinimum = header.getDirMinimum();
        this.leafMinimum = header.getLeafMinimum();
        if (this.getLogger().isDebuggingFine()) {
            this.getLogger().debugFine((CharSequence)(this.getClass() + "\n file = " + file.getClass()));
        }
        this.initialized = true;
    }

    protected final void initialize(E exampleLeaf) {
        this.initializeCapacities(exampleLeaf);
        this.createEmptyRoot(exampleLeaf);
        Logging log = this.getLogger();
        if (log.isStatistics()) {
            String cls = this.getClass().getName();
            log.statistics((Statistic)new LongStatistic(cls + ".directory.capacity", (long)this.dirCapacity));
            log.statistics((Statistic)new LongStatistic(cls + ".directory.minfill", (long)this.dirMinimum));
            log.statistics((Statistic)new LongStatistic(cls + ".leaf.capacity", (long)this.leafCapacity));
            log.statistics((Statistic)new LongStatistic(cls + ".leaf.minfill", (long)this.leafMinimum));
        }
        this.initialized = true;
    }

    public final IndexTreePath<E> getRootPath() {
        return new IndexTreePath<E>(null, this.rootEntry, -1);
    }

    protected abstract void initializeCapacities(E var1);

    protected abstract void createEmptyRoot(E var1);

    protected abstract E createRootEntry();

    protected abstract N createNewLeafNode();

    protected abstract N createNewDirectoryNode();

    protected void preInsert(E entry) {
    }

    protected void postDelete(E entry) {
    }

    public void logStatistics() {
        this.file.logStatistics();
    }

    protected int getPageSize() {
        return this.file.getPageSize();
    }

    @Deprecated
    protected PageFile<N> getFile() {
        return this.file;
    }
}

