/*
 * Decompiled with CFR 0.152.
 */
package elki.index.tree;

import elki.index.tree.IndexTreePath;
import elki.index.tree.LeafEntry;
import elki.index.tree.Node;
import elki.logging.Logging;
import elki.logging.LoggingConfiguration;
import elki.persistent.AbstractExternalizablePage;
import elki.utilities.datastructures.BitsUtil;
import elki.utilities.exceptions.AbortException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractNode<E>
extends AbstractExternalizablePage
implements Node<E> {
    protected int numEntries;
    protected Object[] entries;
    protected boolean isLeaf;

    public AbstractNode() {
    }

    public AbstractNode(int capacity, boolean isLeaf) {
        this.numEntries = 0;
        this.entries = new Object[capacity];
        this.isLeaf = isLeaf;
    }

    @Override
    public final Iterator<IndexTreePath<E>> children(final IndexTreePath<E> parentPath) {
        return new Iterator<IndexTreePath<E>>(){
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < AbstractNode.this.numEntries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IndexTreePath<E> next() {
                AbstractNode abstractNode = AbstractNode.this;
                synchronized (abstractNode) {
                    if (this.count < AbstractNode.this.numEntries) {
                        return new IndexTreePath(parentPath, AbstractNode.this.getEntry(this.count), this.count++);
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public final int getNumEntries() {
        return this.numEntries;
    }

    @Override
    public final boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public final E getEntry(int index) {
        return (E)this.entries[index];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isLeaf);
        out.writeInt(this.numEntries);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isLeaf = in.readBoolean();
        this.numEntries = in.readInt();
    }

    @Override
    public String toString() {
        return (this.isLeaf ? "LeafNode " : "DirNode ") + this.getPageID();
    }

    @Override
    public final int addEntry(E entry) {
        if (entry instanceof LeafEntry != this.isLeaf()) {
            throw new IllegalStateException("Inserting " + (entry instanceof LeafEntry ? "leaf" : "directory") + " entry into a " + (this.isLeaf() ? "leaf" : "directory") + "node.");
        }
        this.entries[this.numEntries] = entry;
        return this.numEntries++;
    }

    public boolean deleteEntry(int index) {
        System.arraycopy(this.entries, index + 1, this.entries, index, this.numEntries - index - 1);
        this.entries[--this.numEntries] = null;
        return true;
    }

    public final void deleteAllEntries() {
        if (this.numEntries > 0) {
            Arrays.fill(this.entries, null);
            this.numEntries = 0;
        }
    }

    public final int getCapacity() {
        return this.entries.length;
    }

    public void removeMask(long[] mask) {
        int src;
        int dest = BitsUtil.nextSetBit((long[])mask, (int)0);
        if (dest < 0) {
            return;
        }
        for (src = BitsUtil.nextSetBit((long[])mask, (int)dest); src < this.numEntries; ++src) {
            if (BitsUtil.get((long[])mask, (int)src)) continue;
            this.entries[dest++] = this.entries[src];
        }
        int rm = src - dest;
        while (dest < this.numEntries) {
            this.entries[dest++] = null;
        }
        this.numEntries -= rm;
    }

    public final void splitTo(AbstractNode<E> newNode, List<E> sorting, int splitPoint) {
        int i;
        assert (this.isLeaf() == newNode.isLeaf());
        this.deleteAllEntries();
        StringBuilder msg = LoggingConfiguration.DEBUG ? new StringBuilder(1000) : null;
        for (i = 0; i < splitPoint; ++i) {
            this.addEntry(sorting.get(i));
            if (msg == null) continue;
            msg.append("n_").append(this.getPageID()).append(' ').append(sorting.get(i)).append('\n');
        }
        for (i = splitPoint; i < sorting.size(); ++i) {
            newNode.addEntry(sorting.get(i));
            if (msg == null) continue;
            msg.append("n_").append(newNode.getPageID()).append(' ').append(sorting.get(i)).append('\n');
        }
        if (msg != null) {
            Logging.getLogger((String)this.getClass().getName()).fine((CharSequence)msg.toString());
        }
    }

    public final void splitTo(AbstractNode<E> newNode, List<E> assignmentsToFirst, List<E> assignmentsToSecond) {
        assert (this.isLeaf() == newNode.isLeaf());
        this.deleteAllEntries();
        StringBuilder msg = LoggingConfiguration.DEBUG ? new StringBuilder(1000) : null;
        for (E entry : assignmentsToFirst) {
            if (msg != null) {
                msg.append("n_").append(this.getPageID()).append(' ').append(entry).append('\n');
            }
            this.addEntry(entry);
        }
        for (E entry : assignmentsToSecond) {
            if (msg != null) {
                msg.append("n_").append(newNode.getPageID()).append(' ').append(entry).append('\n');
            }
            newNode.addEntry(entry);
        }
        if (msg != null) {
            Logging.getLogger(this.getClass()).fine((CharSequence)msg.toString());
        }
    }

    public final void splitByMask(AbstractNode<E> newNode, long[] assignment) {
        assert (this.isLeaf() == newNode.isLeaf());
        int dest = BitsUtil.nextSetBit((long[])assignment, (int)0);
        if (dest < 0) {
            throw new AbortException("No bits set in splitting mask.");
        }
        for (int pos = dest; pos < this.numEntries; ++pos) {
            if (BitsUtil.get((long[])assignment, (int)pos)) {
                newNode.addEntry(this.getEntry(pos));
                continue;
            }
            this.entries[dest++] = this.entries[pos];
        }
        int rm = this.numEntries - dest;
        while (dest < this.numEntries) {
            this.entries[dest++] = null;
        }
        this.numEntries -= rm;
    }
}

