/*
 * Decompiled with CFR 0.152.
 */
package elki.index.projected;

import elki.data.projection.Projection;
import elki.data.type.TypeInformation;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.KNNHeap;
import elki.database.ids.KNNList;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.MaterializedRelation;
import elki.database.relation.ProjectedView;
import elki.database.relation.Relation;
import elki.index.Index;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.index.RKNNIndex;
import elki.index.RangeIndex;
import elki.logging.Logging;
import elki.logging.statistics.Counter;
import elki.logging.statistics.Statistic;
import elki.result.Metadata;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class ProjectedIndex<O, I>
implements KNNIndex<O>,
RKNNIndex<O>,
RangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(ProjectedIndex.class);
    Index inner;
    Projection<O, I> proj;
    Relation<? extends O> relation;
    Relation<I> view;
    boolean norefine;
    double kmulti = 1.0;
    final Counter refinements;

    public ProjectedIndex(Relation<? extends O> relation, Projection<O, I> proj, Relation<I> view, Index inner, boolean norefine, double kmulti) {
        this.relation = relation;
        this.view = view;
        this.inner = inner;
        this.proj = proj;
        this.norefine = norefine;
        this.kmulti = kmulti;
        this.refinements = LOG.isStatistics() ? LOG.newCounter(this.getClass().getName() + ".refinements") : null;
        Metadata.of((Object)this).setLongName("Projected " + Metadata.of((Object)inner).getLongName());
    }

    private void countRefinement() {
        if (this.refinements != null) {
            this.refinements.increment();
        }
    }

    public void initialize() {
        this.inner.initialize();
    }

    public void logStatistics() {
        if (this.refinements != null) {
            LOG.statistics((Statistic)this.refinements);
        }
        this.inner.logStatistics();
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        if (!(this.inner instanceof KNNIndex) || distanceQuery.getRelation() != this.relation || (flags & 4) == 0) {
            return null;
        }
        DistanceQuery innerQuery = distanceQuery.getDistance().instantiate(this.view);
        KNNSearcher innerq = ((KNNIndex)this.inner).kNNByObject(innerQuery, maxk, flags);
        return innerq != null ? new ProjectedKNNByObject(distanceQuery, innerq) : null;
    }

    public KNNSearcher<DBIDRef> kNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        if (!(this.inner instanceof KNNIndex) || distanceQuery.getRelation() != this.relation || (flags & 4) == 0) {
            return null;
        }
        DistanceQuery innerQuery = distanceQuery.getDistance().instantiate(this.view);
        KNNSearcher innerq = ((KNNIndex)this.inner).kNNByObject(innerQuery, maxk, flags);
        return innerq != null ? new ProjectedKNNByDBID(distanceQuery, innerq) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        if (!(this.inner instanceof RangeIndex) || distanceQuery.getRelation() != this.relation || (flags & 4) == 0) {
            return null;
        }
        DistanceQuery innerQuery = distanceQuery.getDistance().instantiate(this.view);
        RangeSearcher innerq = ((RangeIndex)this.inner).rangeByObject(innerQuery, maxradius, flags);
        return innerq != null ? new ProjectedRangeByObject(distanceQuery, innerq) : null;
    }

    public RangeSearcher<DBIDRef> rangeByDBID(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        if (!(this.inner instanceof RangeIndex) || distanceQuery.getRelation() != this.relation || (flags & 4) == 0) {
            return null;
        }
        DistanceQuery innerQuery = distanceQuery.getDistance().instantiate(this.view);
        RangeSearcher innerq = ((RangeIndex)this.inner).rangeByObject(innerQuery, maxradius, flags);
        return innerq != null ? new ProjectedRangeByDBID(distanceQuery, innerq) : null;
    }

    public RKNNSearcher<O> rkNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        if (!(this.inner instanceof RKNNIndex) || distanceQuery.getRelation() != this.relation || (flags & 4) == 0) {
            return null;
        }
        DistanceQuery innerQuery = distanceQuery.getDistance().instantiate(this.view);
        RKNNSearcher innerq = ((RKNNIndex)this.inner).rkNNByObject(innerQuery, maxk, flags);
        return innerq != null ? new ProjectedRKNNByObject(distanceQuery, innerq) : null;
    }

    public RKNNSearcher<DBIDRef> rkNNByDBID(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        if (!(this.inner instanceof RKNNIndex) || distanceQuery.getRelation() != this.relation || (flags & 4) == 0) {
            return null;
        }
        DistanceQuery innerQuery = distanceQuery.getDistance().instantiate(this.view);
        RKNNSearcher innerq = ((RKNNIndex)this.inner).rkNNByObject(innerQuery, maxk, flags);
        return innerq != null ? new ProjectedRKNNByDBID(distanceQuery, innerq) : null;
    }

    public static class Factory<O, I>
    implements IndexFactory<O> {
        Projection<O, I> proj;
        IndexFactory<I> inner;
        boolean materialize = false;
        boolean norefine = false;
        double kmulti = 1.0;

        public Factory(Projection<O, I> proj, IndexFactory<I> inner, boolean materialize, boolean norefine, double kmulti) {
            this.proj = proj;
            this.inner = inner;
            this.materialize = materialize;
            this.norefine = norefine;
            this.kmulti = kmulti;
        }

        public ProjectedIndex<O, I> instantiate(Relation<O> relation) {
            if (!this.proj.getInputDataTypeInformation().isAssignableFromType((TypeInformation)relation.getDataTypeInformation())) {
                return null;
            }
            this.proj.initialize(relation.getDataTypeInformation());
            Index inneri = null;
            ProjectedView view = null;
            if (this.materialize) {
                DBIDs ids = relation.getDBIDs();
                WritableDataStore content = DataStoreUtil.makeStorage((DBIDs)ids, (int)30, (Class)this.proj.getOutputDataTypeInformation().getRestrictionClass());
                DBIDIter iter = ids.iter();
                while (iter.valid()) {
                    content.put((DBIDRef)iter, this.proj.project(relation.get((DBIDRef)iter)));
                    iter.advance();
                }
                view = new MaterializedRelation("Projected Index", this.proj.getOutputDataTypeInformation(), ids, (DataStore)content);
            } else {
                view = new ProjectedView(relation, this.proj);
            }
            inneri = this.inner.instantiate((Relation)view);
            if (inneri == null) {
                return null;
            }
            return new ProjectedIndex<O, I>(relation, this.proj, view, inneri, this.norefine, this.kmulti);
        }

        public TypeInformation getInputTypeRestriction() {
            return this.proj.getInputDataTypeInformation();
        }

        public static class Par<O, I>
        implements Parameterizer {
            public static final OptionID PROJ_ID = new OptionID("projindex.proj", "Projection to use for the projected index.");
            public static final OptionID INDEX_ID = new OptionID("projindex.inner", "Index to use on the projected data.");
            public static final OptionID MATERIALIZE_FLAG = new OptionID("projindex.materialize", "Flag to materialize the projected data.");
            public static final OptionID DISABLE_REFINE_FLAG = new OptionID("projindex.disable-refine", "Flag to disable refinement of distances.");
            public static final OptionID K_MULTIPLIER_ID = new OptionID("projindex.kmulti", "Multiplier for k.");
            Projection<O, I> proj;
            IndexFactory<I> inner;
            boolean materialize = false;
            boolean norefine = false;
            double kmulti = 1.0;

            public void configure(Parameterization config) {
                new ObjectParameter(PROJ_ID, Projection.class).grab(config, x -> {
                    this.proj = x;
                });
                new ObjectParameter(INDEX_ID, IndexFactory.class).grab(config, x -> {
                    this.inner = x;
                });
                new Flag(MATERIALIZE_FLAG).grab(config, x -> {
                    this.materialize = x;
                });
                new Flag(DISABLE_REFINE_FLAG).grab(config, x -> {
                    this.norefine = x;
                });
                if (!this.norefine) {
                    ((DoubleParameter)((DoubleParameter)new DoubleParameter(K_MULTIPLIER_ID).setDefaultValue((Object)1.0)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_DOUBLE)).grab(config, x -> {
                        this.kmulti = x;
                    });
                }
            }

            public Factory<O, I> make() {
                return new Factory<O, I>(this.proj, this.inner, this.materialize, this.norefine, this.kmulti);
            }
        }
    }

    class ProjectedRKNNByDBID
    implements RKNNSearcher<DBIDRef> {
        RKNNSearcher<I> inner;
        DistanceQuery<O> distq;

        public ProjectedRKNNByDBID(DistanceQuery<O> distanceQuery, RKNNSearcher<I> inner) {
            this.inner = inner;
            this.distq = distanceQuery;
        }

        public DoubleDBIDList getRKNN(DBIDRef id, int k) {
            Object obj = ProjectedIndex.this.relation.get(id);
            Object pobj = ProjectedIndex.this.proj.project(obj);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getRKNN(pobj, k);
            }
            DoubleDBIDList ilist = this.inner.getRKNN(pobj, (int)Math.ceil((double)k * ProjectedIndex.this.kmulti));
            ModifiableDoubleDBIDList olist = DBIDUtil.newDistanceDBIDList((int)ilist.size());
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                double dist = this.distq.distance(obj, (DBIDRef)iter);
                ProjectedIndex.this.countRefinement();
                olist.add(dist, (DBIDRef)iter);
                iter.advance();
            }
            return olist;
        }
    }

    class ProjectedRKNNByObject
    implements RKNNSearcher<O> {
        RKNNSearcher<I> inner;
        DistanceQuery<O> distq;

        public ProjectedRKNNByObject(DistanceQuery<O> distanceQuery, RKNNSearcher<I> inner) {
            this.inner = inner;
            this.distq = distanceQuery;
        }

        public DoubleDBIDList getRKNN(O obj, int k) {
            Object pobj = ProjectedIndex.this.proj.project(obj);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getRKNN(pobj, k);
            }
            DoubleDBIDList ilist = this.inner.getRKNN(pobj, (int)Math.ceil((double)k * ProjectedIndex.this.kmulti));
            ModifiableDoubleDBIDList olist = DBIDUtil.newDistanceDBIDList((int)ilist.size());
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                double dist = this.distq.distance(obj, (DBIDRef)iter);
                ProjectedIndex.this.countRefinement();
                olist.add(dist, (DBIDRef)iter);
                iter.advance();
            }
            return olist;
        }
    }

    class ProjectedRangeByDBID
    implements RangeSearcher<DBIDRef> {
        protected final DistanceQuery<O> distanceQuery;
        RangeSearcher<I> inner;

        public ProjectedRangeByDBID(DistanceQuery<O> distanceQuery, RangeSearcher<I> inner) {
            this.distanceQuery = distanceQuery;
            this.inner = inner;
        }

        public ModifiableDoubleDBIDList getRange(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
            Object obj = ProjectedIndex.this.relation.get(id);
            DoubleDBIDList ilist = this.inner.getRange(ProjectedIndex.this.proj.project(obj), range);
            if (ProjectedIndex.this.norefine) {
                DoubleDBIDListIter iter = ilist.iter();
                while (iter.valid()) {
                    result.add(iter.doubleValue(), (DBIDRef)iter);
                    iter.advance();
                }
                return result;
            }
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                double dist = this.distanceQuery.distance(obj, (DBIDRef)iter);
                ProjectedIndex.this.countRefinement();
                if (range <= dist) {
                    result.add(dist, (DBIDRef)iter);
                }
                iter.advance();
            }
            return result;
        }
    }

    class ProjectedRangeByObject
    implements RangeSearcher<O> {
        protected final DistanceQuery<O> distanceQuery;
        RangeSearcher<I> inner;

        public ProjectedRangeByObject(DistanceQuery<O> distanceQuery, RangeSearcher<I> inner) {
            this.distanceQuery = distanceQuery;
            this.inner = inner;
        }

        public ModifiableDoubleDBIDList getRange(O obj, double range, ModifiableDoubleDBIDList result) {
            DoubleDBIDList ilist = this.inner.getRange(ProjectedIndex.this.proj.project(obj), range);
            if (ProjectedIndex.this.norefine) {
                DoubleDBIDListIter iter = ilist.iter();
                while (iter.valid()) {
                    result.add(iter.doubleValue(), (DBIDRef)iter);
                    iter.advance();
                }
                return result;
            }
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                double dist = this.distanceQuery.distance(obj, (DBIDRef)iter);
                ProjectedIndex.this.countRefinement();
                if (range <= dist) {
                    result.add(dist, (DBIDRef)iter);
                }
                iter.advance();
            }
            return result;
        }
    }

    class ProjectedKNNByDBID
    implements KNNSearcher<DBIDRef> {
        KNNSearcher<I> inner;
        DistanceQuery<O> distq;

        public ProjectedKNNByDBID(DistanceQuery<O> distanceQuery, KNNSearcher<I> inner) {
            this.inner = inner;
            this.distq = distanceQuery;
        }

        public KNNList getKNN(DBIDRef id, int k) {
            Object obj = ProjectedIndex.this.relation.get(id);
            Object pobj = ProjectedIndex.this.proj.project(obj);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getKNN(pobj, k);
            }
            KNNList ilist = this.inner.getKNN(pobj, (int)Math.ceil((double)k * ProjectedIndex.this.kmulti));
            KNNHeap heap = DBIDUtil.newHeap((int)k);
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                heap.insert(this.distq.distance(obj, (DBIDRef)iter), (DBIDRef)iter);
                ProjectedIndex.this.countRefinement();
                iter.advance();
            }
            return heap.toKNNList();
        }
    }

    class ProjectedKNNByObject
    implements KNNSearcher<O> {
        KNNSearcher<I> inner;
        DistanceQuery<O> distq;

        public ProjectedKNNByObject(DistanceQuery<O> distanceQuery, KNNSearcher<I> inner) {
            this.inner = inner;
            this.distq = distanceQuery;
        }

        public KNNList getKNN(O obj, int k) {
            Object pobj = ProjectedIndex.this.proj.project(obj);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getKNN(pobj, k);
            }
            KNNList ilist = this.inner.getKNN(pobj, (int)Math.ceil((double)k * ProjectedIndex.this.kmulti));
            KNNHeap heap = DBIDUtil.newHeap((int)k);
            DoubleDBIDListIter iter = ilist.iter();
            while (iter.valid()) {
                heap.insert(this.distq.distance(obj, (DBIDRef)iter), (DBIDRef)iter);
                ProjectedIndex.this.countRefinement();
                iter.advance();
            }
            return heap.toKNNList();
        }
    }
}

