/*
 * Decompiled with CFR 0.152.
 */
package elki.index.distancematrix;

import elki.data.type.TypeInformation;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.query.range.RangeSearcher;
import elki.database.query.similarity.SimilarityQuery;
import elki.database.relation.Relation;
import elki.index.IndexFactory;
import elki.index.SimilarityIndex;
import elki.index.SimilarityRangeIndex;
import elki.logging.Logging;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.similarity.Similarity;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class PrecomputedSimilarityMatrix<O>
implements SimilarityIndex<O>,
SimilarityRangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(PrecomputedSimilarityMatrix.class);
    protected final Relation<O> relation;
    protected Similarity<? super O> similarityFunction;
    protected SimilarityQuery<O> similarityQuery;
    private double[] matrix = null;
    private DBIDRange ids;
    private int size;

    public PrecomputedSimilarityMatrix(Relation<O> relation, Similarity<? super O> similarityFunction) {
        this.relation = relation;
        this.similarityFunction = similarityFunction;
        if (!similarityFunction.isSymmetric()) {
            throw new AbortException("Similarity matrixes currently only support symmetric similarity functions (Patches welcome).");
        }
    }

    public void initialize() {
        DBIDs rids = this.relation.getDBIDs();
        if (!(rids instanceof DBIDRange)) {
            throw new AbortException("Similarity matrixes are currently only supported for DBID ranges (as used by static databases) for performance reasons (Patches welcome).");
        }
        this.ids = (DBIDRange)rids;
        this.size = this.ids.size();
        if (this.size > 65536) {
            throw new AbortException("Similarity matrixes currently have a limit of 65536 objects (~16 GB). After this, the array size exceeds the Java integer range, and a different data structure needs to be used.");
        }
        this.similarityQuery = this.similarityFunction.instantiate(this.relation);
        int msize = PrecomputedSimilarityMatrix.triangleSize(this.size);
        this.matrix = new double[msize];
        DBIDArrayIter ix = this.ids.iter();
        DBIDArrayIter iy = this.ids.iter();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Precomputing similarity matrix", msize, LOG) : null;
        int pos = 0;
        ix.seek(0);
        while (ix.valid()) {
            iy.seek(0);
            while (iy.getOffset() < ix.getOffset()) {
                this.matrix[pos] = this.similarityQuery.similarity((DBIDRef)ix, (DBIDRef)iy);
                ++pos;
                iy.advance();
            }
            if (prog != null) {
                prog.setProcessed(prog.getProcessed() + ix.getOffset(), LOG);
            }
            ix.advance();
        }
        LOG.ensureCompleted(prog);
    }

    protected static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    private int getOffset(int x, int y) {
        return y < x ? PrecomputedSimilarityMatrix.triangleSize(x) + y : PrecomputedSimilarityMatrix.triangleSize(y) + x;
    }

    public void logStatistics() {
        if (this.matrix != null) {
            LOG.statistics((Statistic)new LongStatistic(this.getClass().getName() + ".matrix-size", (long)this.matrix.length));
        }
    }

    public SimilarityQuery<O> getSimilarityQuery(Similarity<? super O> similarityFunction) {
        return this.similarityFunction.equals(similarityFunction) ? new PrecomputedSimilarityQuery() : null;
    }

    public RangeSearcher<DBIDRef> similarityRangeByDBID(SimilarityQuery<O> simQuery, double maxradius, int flags) {
        return this.similarityFunction.equals((Object)simQuery.getSimilarity()) ? new PrecomputedSimilarityRangeQuery() : null;
    }

    public RangeSearcher<O> similarityRangeByObject(SimilarityQuery<O> simQuery, double maxrange, int flags) {
        return null;
    }

    public static class Factory<O>
    implements IndexFactory<O> {
        protected final Similarity<? super O> similarityFunction;

        public Factory(Similarity<? super O> similarityFunction) {
            this.similarityFunction = similarityFunction;
        }

        public PrecomputedSimilarityMatrix<O> instantiate(Relation<O> relation) {
            return new PrecomputedSimilarityMatrix<O>(relation, this.similarityFunction);
        }

        public TypeInformation getInputTypeRestriction() {
            return this.similarityFunction.getInputTypeRestriction();
        }

        public static class Par<O>
        implements Parameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("matrix.similarity", "Similarity function for the precomputed similarity matrix.");
            protected Similarity<? super O> similarityFunction;

            public void configure(Parameterization config) {
                new ObjectParameter(DISTANCE_ID, Similarity.class).grab(config, x -> {
                    this.similarityFunction = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.similarityFunction);
            }
        }
    }

    private class PrecomputedSimilarityRangeQuery
    implements RangeSearcher<DBIDRef> {
        private PrecomputedSimilarityRangeQuery() {
        }

        public ModifiableDoubleDBIDList getRange(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
            double sim;
            int y;
            result.add(0.0, id);
            DBIDArrayIter it = PrecomputedSimilarityMatrix.this.ids.iter();
            int x = PrecomputedSimilarityMatrix.this.ids.getOffset(id);
            int pos = PrecomputedSimilarityMatrix.triangleSize(x);
            for (y = 0; y < x; ++y) {
                sim = PrecomputedSimilarityMatrix.this.matrix[pos];
                if (sim >= range) {
                    result.add(sim, (DBIDRef)it.seek(y));
                }
                ++pos;
            }
            assert (pos == PrecomputedSimilarityMatrix.triangleSize(x + 1));
            pos = PrecomputedSimilarityMatrix.triangleSize(x + 1) + x;
            for (y = x + 1; y < PrecomputedSimilarityMatrix.this.size; ++y) {
                sim = PrecomputedSimilarityMatrix.this.matrix[pos];
                if (sim >= range) {
                    result.add(sim, (DBIDRef)it.seek(y));
                }
                pos += y;
            }
            return result;
        }
    }

    private class PrecomputedSimilarityQuery
    implements SimilarityQuery<O> {
        private PrecomputedSimilarityQuery() {
        }

        public double similarity(DBIDRef id1, DBIDRef id2) {
            int y;
            int x = PrecomputedSimilarityMatrix.this.ids.getOffset(id1);
            return x != (y = PrecomputedSimilarityMatrix.this.ids.getOffset(id2)) ? PrecomputedSimilarityMatrix.this.matrix[PrecomputedSimilarityMatrix.this.getOffset(x, y)] : 0.0;
        }

        public double similarity(O o1, DBIDRef id2) {
            return PrecomputedSimilarityMatrix.this.similarityQuery.similarity(o1, id2);
        }

        public double similarity(DBIDRef id1, O o2) {
            return PrecomputedSimilarityMatrix.this.similarityQuery.similarity(id1, o2);
        }

        public double similarity(O o1, O o2) {
            return PrecomputedSimilarityMatrix.this.similarityQuery.similarity(o1, o2);
        }

        public Similarity<? super O> getSimilarity() {
            return PrecomputedSimilarityMatrix.this.similarityQuery.getSimilarity();
        }

        public Relation<? extends O> getRelation() {
            return PrecomputedSimilarityMatrix.this.relation;
        }
    }
}

