/*
 * Decompiled with CFR 0.152.
 */
package elki.index;

import elki.index.IndexFactory;
import elki.persistent.MemoryPageFileFactory;
import elki.persistent.Page;
import elki.persistent.PageFile;
import elki.persistent.PageFileFactory;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.Externalizable;

public abstract class PagedIndexFactory<O>
implements IndexFactory<O> {
    private PageFileFactory<?> pageFileFactory;

    public PagedIndexFactory(PageFileFactory<?> pageFileFactory) {
        this.pageFileFactory = pageFileFactory;
    }

    protected <N extends Page & Externalizable> PageFile<N> makePageFile(Class<N> cls) {
        PageFileFactory<?> castFactory = this.pageFileFactory;
        return castFactory.newPageFile(cls);
    }

    public static abstract class Par<O>
    implements Parameterizer {
        public static final OptionID PAGEFILE_ID = new OptionID("index.pagefile", "The pagefile factory for storing the index.");
        protected PageFileFactory<?> pageFileFactory;

        public void configure(Parameterization config) {
            new ObjectParameter(PAGEFILE_ID, PageFileFactory.class, MemoryPageFileFactory.class).grab(config, x -> {
                this.pageFileFactory = x;
            });
        }

        public abstract PagedIndexFactory<O> make();
    }
}

