/*
 * Decompiled with CFR 0.152.
 */
package elki.index;

import elki.database.ids.DBID;
import elki.database.ids.DBIDRef;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.index.Index;
import elki.logging.Logging;
import elki.logging.statistics.Counter;
import elki.logging.statistics.Statistic;

public abstract class AbstractRefiningIndex<O>
implements Index {
    protected final Relation<O> relation;
    private Counter refinements;

    public AbstractRefiningIndex(Relation<O> relation) {
        this.relation = relation;
        this.refinements = this.getLogger().isStatistics() ? this.getLogger().newCounter(this.getClass().getName() + ".refinements") : null;
    }

    public abstract Logging getLogger();

    protected void countRefinements(int i) {
        if (this.refinements != null) {
            this.refinements.increment((long)i);
        }
    }

    public void logStatistics() {
        if (this.refinements != null) {
            this.getLogger().statistics((Statistic)this.refinements);
        }
    }

    protected O refine(DBID id) {
        this.countRefinements(1);
        return (O)this.relation.get((DBIDRef)id);
    }

    public abstract class AbstractRefiningQuery {
        protected DistanceQuery<O> distanceQuery;

        public AbstractRefiningQuery(DistanceQuery<O> distanceQuery) {
            this.distanceQuery = distanceQuery;
        }

        protected double refine(DBIDRef id, O q) {
            AbstractRefiningIndex.this.countRefinements(1);
            return this.distanceQuery.distance(q, id);
        }

        protected void incRefinements(int c) {
            AbstractRefiningIndex.this.countRefinements(c);
        }
    }
}

