/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.random;

import elki.utilities.documentation.Reference;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="S. Vigna", title="An experimental exploration of Marsaglia's xorshift generators, scrambled", booktitle="Online", url="http://vigna.di.unimi.it/ftp/papers/xorshift.pdf", bibkey="web/Vigna14")
public class XorShift64NonThreadsafeRandom
extends Random {
    private static final long serialVersionUID = 1L;
    long x;
    protected static final String BADBOUND = "bound must be positive";

    public XorShift64NonThreadsafeRandom() {
        super(4101842887655102017L);
    }

    public XorShift64NonThreadsafeRandom(long seed) {
        super(RandomFactory.murmurMix64(seed));
    }

    @Override
    public synchronized void setSeed(long seed) {
        this.x = seed != 0L ? seed : 4101842887655102017L;
    }

    @Override
    public long nextLong() {
        this.x ^= this.x >>> 12;
        this.x ^= this.x << 25;
        this.x ^= this.x >>> 27;
        return this.x * 2685821657736338717L;
    }

    @Override
    protected int next(int bits) {
        return (int)(this.nextLong() >>> 64 - bits);
    }

    @Override
    public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    @Reference(authors="D. Lemire", title="Fast random shuffling", booktitle="Daniel Lemire's blog", url="http://lemire.me/blog/2016/06/30/fast-random-shuffling/", bibkey="blog/Lemire16")
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BADBOUND);
        }
        return (int)((this.nextLong() >>> 32) * (long)n >>> 32);
    }
}

