/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.random;

import elki.logging.LoggingUtil;
import elki.utilities.random.Xoroshiro128NonThreadsafeRandom;
import java.util.Random;

public class RandomFactory {
    public static final RandomFactory DEFAULT = new RandomFactory(RandomFactory.getGlobalSeed()){

        @Override
        public String toString() {
            return "GlobalRandom[" + Long.toString(this.seed) + "]";
        }
    };
    protected long seed;

    private static long getGlobalSeed() {
        String sseed = System.getProperty("elki.seed");
        try {
            return sseed != null && sseed.length() > 0 ? Long.parseLong(sseed) : System.nanoTime();
        }
        catch (NumberFormatException e) {
            LoggingUtil.warning((String)("Failed to parse elki.seed environment variable containing '" + sseed + "', falling back to system time for seeding."));
            return System.nanoTime();
        }
    }

    public static RandomFactory get(Long seed) {
        return seed == null ? DEFAULT : new RandomFactory(seed);
    }

    public RandomFactory(long seed) {
        this.seed = seed;
    }

    public Random getRandom() {
        return new Random(RandomFactory.murmurMix64(this.seed++));
    }

    public Random getSingleThreadedRandom() {
        return new Xoroshiro128NonThreadsafeRandom(RandomFactory.murmurMix64(this.seed++));
    }

    public static int murmurMix32(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    public static long murmurMix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public String toString() {
        return "Random[" + Long.toString(this.seed) + "]";
    }
}

