/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.pairs;

import java.util.Comparator;

public class IntIntPair
implements Comparable<IntIntPair> {
    public int first;
    public int second;
    public static final Comparator<IntIntPair> BYFIRST_COMPARATOR = (o1, o2) -> o1.first - o2.first;
    public static final Comparator<IntIntPair> BYSECOND_COMPARATOR = (o1, o2) -> o1.second - o2.second;
    public static final Comparator<IntIntPair> SWAPPED_COMPARATOR = (o1, o2) -> o1.compareSwappedTo((IntIntPair)o2);

    public IntIntPair(int first, int second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntIntPair other = (IntIntPair)obj;
        return this.first == other.first && this.second == other.second;
    }

    public final int hashCode() {
        return this.first * -1640531535 + this.second;
    }

    @Override
    public int compareTo(IntIntPair other) {
        int fdiff = this.first - other.first;
        return fdiff != 0 ? fdiff : this.second - other.second;
    }

    public int compareSwappedTo(IntIntPair other) {
        int fdiff = this.second - other.second;
        return fdiff != 0 ? fdiff : this.first - other.first;
    }

    public final void setFirst(int first) {
        this.first = first;
    }

    public final void setSecond(int second) {
        this.second = second;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }
}

