/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.pairs;

import java.util.Comparator;

public class IntDoublePair
implements Comparable<IntDoublePair> {
    public int first;
    public double second;
    public static final Comparator<IntDoublePair> BYFIRST_COMPARATOR = (o1, o2) -> o1.first - o2.first;
    public static final Comparator<IntDoublePair> BYSECOND_COMPARATOR = (o1, o2) -> Double.compare(o1.second, o2.second);
    public static final Comparator<IntDoublePair> SWAPPED_COMPARATOR = (o1, o2) -> o1.compareSwappedTo((IntDoublePair)o2);

    public IntDoublePair(int first, double second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntDoublePair other = (IntDoublePair)obj;
        return this.first == other.first && this.second == other.second;
    }

    public final int hashCode() {
        long secondhash = Double.doubleToLongBits(this.second);
        secondhash ^= secondhash >> 32;
        return this.first * -1640531535 + (int)secondhash;
    }

    @Override
    public int compareTo(IntDoublePair other) {
        int fdiff = this.first - other.first;
        return fdiff != 0 ? fdiff : Double.compare(this.second, other.second);
    }

    public int compareSwappedTo(IntDoublePair other) {
        int fdiff = Double.compare(this.second, other.second);
        return fdiff != 0 ? fdiff : this.first - other.first;
    }

    public final void setFirst(int first) {
        this.first = first;
    }

    public final void setSecond(double second) {
        this.second = second;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }
}

