/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.function.Consumer;

public class StringParameter
extends AbstractParameter<StringParameter, String> {
    public StringParameter(OptionID optionID, String defaultValue) {
        super(optionID, defaultValue);
    }

    public StringParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return (String)this.getValue();
    }

    @Override
    protected String parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new WrongParameterValueException("String parameter " + this.getOptionID().getName() + " is not a string.");
    }

    @Override
    public String getSyntax() {
        return "<string>";
    }

    public boolean grab(Parameterization config, Consumer<String> consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept((String)this.getValue());
            }
            return true;
        }
        return false;
    }
}

