/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternParameter
extends AbstractParameter<PatternParameter, Pattern> {
    public PatternParameter(OptionID optionID, Pattern defaultValue) {
        super(optionID, defaultValue);
    }

    public PatternParameter(OptionID optionID, String defaultValue) {
        super(optionID, Pattern.compile(defaultValue, 2));
    }

    public PatternParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Pattern)this.getValue()).toString();
    }

    @Override
    protected Pattern parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof Pattern) {
            return (Pattern)obj;
        }
        if (obj instanceof String) {
            try {
                return Pattern.compile((String)obj, 2);
            }
            catch (PatternSyntaxException e) {
                throw new WrongParameterValueException("Given pattern \"" + obj + "\" for parameter \"" + this.getOptionID().getName() + "\" is no valid regular expression!");
            }
        }
        throw new WrongParameterValueException("Given pattern \"" + obj + "\" for parameter \"" + this.getOptionID().getName() + "\" is of unknown type!");
    }

    @Override
    public String getSyntax() {
        return "<pattern>";
    }

    public boolean grab(Parameterization config, Consumer<Pattern> consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept((Pattern)this.getValue());
            }
            return true;
        }
        return false;
    }
}

