/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;

public class ObjectParameter<C>
extends ClassParameter<C> {
    private C instance;

    public ObjectParameter(OptionID optionID, Class<?> restrictionClass, Class<?> defaultValue) {
        super(optionID, restrictionClass, defaultValue);
    }

    public <T extends C> ObjectParameter(OptionID optionID, Class<?> restrictionClass, T defaultValue) {
        super(optionID, restrictionClass);
        this.instance = defaultValue;
    }

    public ObjectParameter(OptionID optionID, Class<?> restrictionClass) {
        super(optionID, restrictionClass);
    }

    @Override
    protected Class<? extends C> parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (this.restrictionClass.isInstance(obj)) {
            return obj.getClass();
        }
        return super.parseValue(obj);
    }

    @Override
    public void setValue(Object obj) throws ParameterException {
        if (this.restrictionClass.isInstance(obj)) {
            this.instance = obj;
        }
        super.setValue(obj);
    }

    @Override
    public ObjectParameter<C> setOptional(boolean opt) {
        super.setOptional(opt);
        return this;
    }

    @Override
    public String getSyntax() {
        return "<class|object>";
    }

    @Override
    public C instantiateClass(Parameterization config) {
        return this.instance != null ? this.instance : (this.instance = super.instantiateClass(config));
    }
}

