/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.ClassGenericsUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ObjectListParameter<C>
extends ClassListParameter<C> {
    private List<C> instances = null;

    public ObjectListParameter(OptionID optionID, Class<?> restrictionClass) {
        super(optionID, restrictionClass);
    }

    @Override
    public String getSyntax() {
        return "<object_1|class_1,...,object_n|class_n>";
    }

    @Override
    protected List<Class<? extends C>> parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (List.class.isInstance(obj)) {
            List l = (List)obj;
            ArrayList<C> inst = new ArrayList<C>(l.size());
            ArrayList<Class> classes = new ArrayList<Class>(l.size());
            for (Object o : l) {
                if (this.restrictionClass.isInstance(o)) {
                    inst.add(o);
                    classes.add(o.getClass());
                    continue;
                }
                if (o instanceof Class) {
                    if (this.restrictionClass.isAssignableFrom((Class)o)) {
                        inst.add(null);
                        classes.add((Class)o);
                        continue;
                    }
                    throw new WrongParameterValueException(this, ((Class)o).getName(), "Given class not a subclass / implementation of " + this.restrictionClass.getName());
                }
                throw new WrongParameterValueException(this, o.getClass().getName(), "Given instance not an implementation of " + this.restrictionClass.getName());
            }
            this.instances = inst;
            return super.parseValue(classes);
        }
        try {
            Object inst = this.restrictionClass.cast(obj);
            this.instances = Arrays.asList(inst);
            return super.parseValue(inst.getClass());
        }
        catch (ClassCastException classCastException) {
            return super.parseValue(obj);
        }
    }

    @Override
    public ObjectListParameter<C> setOptional(boolean opt) {
        super.setOptional(opt);
        return this;
    }

    @Override
    public List<C> instantiateClasses(Parameterization config) {
        if (this.instances == null) {
            this.instances = super.instantiateClasses(config);
            return this.instances;
        }
        Parameterization cfg = null;
        List classes = (List)this.getValue();
        for (int i = 0; i < classes.size(); ++i) {
            if (this.instances.get(i) != null) continue;
            Class cls = (Class)classes.get(i);
            try {
                cfg = cfg == null ? config.descend(this) : cfg;
                this.instances.set(i, ClassGenericsUtil.tryInstantiate(this.restrictionClass, cls, cfg));
                continue;
            }
            catch (Exception e) {
                config.reportError(new WrongParameterValueException(this, cls.getName(), e.getMessage(), e));
            }
        }
        return this.instances;
    }
}

