/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.io.ParseUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.NumberParameter;
import java.util.function.LongConsumer;

public class LongParameter
extends NumberParameter<LongParameter, Long> {
    public LongParameter(OptionID optionID, long defaultValue) {
        super(optionID, defaultValue);
    }

    public LongParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Long)this.getValue()).toString();
    }

    @Override
    protected Long parseValue(Object obj) throws ParameterException {
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return ParseUtil.parseLongBase10(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a long value, read: " + obj + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<long>";
    }

    public boolean grab(Parameterization config, LongConsumer consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept((Long)this.getValue());
            }
            return true;
        }
        return false;
    }
}

