/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.io.ParseUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.NumberParameter;
import java.util.function.IntConsumer;

public class IntParameter
extends NumberParameter<IntParameter, Integer> {
    public IntParameter(OptionID optionID, int defaultValue) {
        super(optionID, defaultValue);
    }

    public IntParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Integer)this.getValue()).toString();
    }

    @Override
    protected Integer parseValue(Object obj) throws ParameterException {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return ParseUtil.parseIntBase10(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires an integer value, read: " + obj + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<int>";
    }

    public int intValue() {
        return (Integer)this.getValue();
    }

    public boolean grab(Parameterization config, IntConsumer consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept(this.intValue());
            }
            return true;
        }
        return false;
    }
}

