/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.datastructures.range.IntGenerator;
import elki.utilities.datastructures.range.ParseIntRanges;
import elki.utilities.datastructures.range.StaticIntGenerator;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.function.Consumer;

public class IntGeneratorParameter
extends AbstractParameter<IntGeneratorParameter, IntGenerator> {
    public IntGeneratorParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((IntGenerator)this.getValue()).serializeTo(new StringBuilder(1000)).toString();
    }

    @Override
    public String getDefaultValueAsString() {
        return ((IntGenerator)this.getValue()).serializeTo(new StringBuilder(1000)).toString();
    }

    @Override
    protected IntGenerator parseValue(Object obj) throws ParameterException {
        if (obj instanceof int[]) {
            return new StaticIntGenerator((int[])obj);
        }
        if (obj instanceof IntGenerator) {
            return (IntGenerator)obj;
        }
        if (obj instanceof String && !((String)obj).isEmpty()) {
            try {
                return ParseIntRanges.parseIntRanges((String)obj);
            }
            catch (NumberFormatException e) {
                throw new WrongParameterValueException(this, obj.toString(), "not a valid range of integers", e);
            }
        }
        if (obj instanceof Integer) {
            return new StaticIntGenerator((Integer)obj);
        }
        throw new WrongParameterValueException(this, obj.toString(), "requires a range of integers!");
    }

    @Override
    public String getSyntax() {
        return "<start,+=increment,end,...,start,*=factor,end,int1,int2>";
    }

    public boolean grab(Parameterization config, Consumer<IntGenerator> consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept((IntGenerator)this.getValue());
            }
            return true;
        }
        return false;
    }
}

