/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.AbstractParameter;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;

public class FileParameter
extends AbstractParameter<FileParameter, URI> {
    private FileType fileType;

    public FileParameter(OptionID optionID, FileType fileType) {
        super(optionID);
        this.fileType = fileType;
    }

    @Override
    public String getValueAsString() {
        URI v = (URI)this.getValue();
        return v == null ? null : ("file".equals(v.getScheme()) ? Paths.get(v).toString() : v.normalize().toString());
    }

    @Override
    protected URI parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof URI) {
            return (URI)obj;
        }
        if (obj instanceof URL) {
            try {
                return ((URL)obj).toURI();
            }
            catch (URISyntaxException e) {
                throw new WrongParameterValueException(this, obj.toString(), e.getMessage());
            }
        }
        if (obj instanceof Path) {
            return ((Path)obj).toUri();
        }
        if (obj instanceof File) {
            return ((File)obj).toURI();
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (!str.isEmpty() && str.charAt(0) != '/') {
                try {
                    URI u = new URI(str);
                    if (u.getScheme() != null) {
                        return u;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            return Paths.get(str, new String[0]).toUri();
        }
        throw new WrongParameterValueException(this, obj.toString(), "Unsupported value");
    }

    @Override
    protected boolean validate(URI obj) throws ParameterException {
        if (!super.validate(obj)) {
            return false;
        }
        if (this.fileType.equals((Object)FileType.INPUT_FILE)) {
            try {
                if (FileUtil.exists(obj)) {
                    return true;
                }
                throw new WrongParameterValueException("Given file " + obj + " for parameter \"" + this.getOptionID().getName() + "\" does not exist!");
            }
            catch (SecurityException e) {
                throw new WrongParameterValueException("Given file \"" + obj + "\" cannot be read, access denied!\n" + e.getMessage());
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "<file>";
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean grab(Parameterization config, Consumer<URI> consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept((URI)this.getValue());
            }
            return true;
        }
        return false;
    }

    public static enum FileType {
        INPUT_FILE,
        OUTPUT_FILE;

    }
}

