/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.io.FileUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ListParameter;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class FileListParameter
extends ListParameter<FileListParameter, List<URI>> {
    private FilesType filesType;

    public FileListParameter(OptionID optionID, FilesType filesType) {
        super(optionID);
        this.filesType = filesType;
    }

    @Override
    public String getValueAsString() {
        StringBuilder buf = new StringBuilder(100 * ((List)this.getValue()).size());
        for (URI p : (List)this.getValue()) {
            buf.append(p.toString()).append(",");
        }
        buf.setLength(buf.length() > ",".length() ? buf.length() - ",".length() : buf.length());
        return buf.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        StringBuilder buf = new StringBuilder(100 * ((List)this.getDefaultValue()).size());
        for (URI p : (List)this.getDefaultValue()) {
            buf.append(p.toString()).append(",");
        }
        buf.setLength(buf.length() > ",".length() ? buf.length() - ",".length() : buf.length());
        return buf.toString();
    }

    @Override
    protected List<URI> parseValue(Object obj) throws ParameterException {
        try {
            List l = (List)List.class.cast(obj);
            ArrayList<URI> r = new ArrayList<URI>(l.size());
            for (Object o : l) {
                if (o instanceof URI) {
                    r.add((URI)o);
                }
                if (o instanceof URL) {
                    try {
                        r.add(((URL)o).toURI());
                    }
                    catch (URISyntaxException e) {
                        throw new WrongParameterValueException(this, o.toString(), e.getMessage());
                    }
                }
                if (o instanceof Path) {
                    r.add(((Path)o).toUri());
                    continue;
                }
                if (o instanceof File) {
                    r.add(((File)o).toURI());
                    continue;
                }
                if (o instanceof String) {
                    String str = (String)o;
                    if (!str.isEmpty() && str.charAt(0) != '/') {
                        try {
                            URI u = new URI(str);
                            if (u.getScheme() != null) {
                                r.add(u);
                                continue;
                            }
                        }
                        catch (URISyntaxException u) {
                            // empty catch block
                        }
                    }
                    r.add(Paths.get(str, new String[0]).toUri());
                    continue;
                }
                throw new WrongParameterValueException(this, obj.toString(), "expected a List<Path> or a String.");
            }
            return r;
        }
        catch (ClassCastException l) {
            if (obj instanceof String) {
                String[] values = SPLIT.split((String)obj);
                ArrayList<URI> fileValue = new ArrayList<URI>(values.length);
                for (String val : values) {
                    URI u = URI.create(val);
                    fileValue.add(u.getScheme() != null ? u : Paths.get(val, new String[0]).toUri());
                }
                return fileValue;
            }
            throw new WrongParameterValueException(this, obj.toString(), "expected a String containing file names.");
        }
    }

    @Override
    protected boolean validate(List<URI> obj) throws ParameterException {
        if (!super.validate(obj)) {
            return false;
        }
        if (this.filesType.equals((Object)FilesType.INPUT_FILES)) {
            for (URI file : obj) {
                try {
                    if (FileUtil.exists(file)) continue;
                    throw new WrongParameterValueException(this, this.getValueAsString(), "File \"" + file + "\" does not exist.");
                }
                catch (SecurityException e) {
                    throw new WrongParameterValueException(this, this.getValueAsString(), "File \"" + file + "\" cannot be read, access denied.", e);
                }
            }
        }
        return true;
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    @Override
    public String getSyntax() {
        return "<file_1,...,file_n>";
    }

    public boolean grab(Parameterization config, Consumer<List<URI>> consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept((List)this.getValue());
            }
            return true;
        }
        return false;
    }

    public static enum FilesType {
        INPUT_FILES,
        OUTPUT_FILES;

    }
}

