/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public class EnumParameter<E extends Enum<E>>
extends AbstractParameter<EnumParameter<E>, E> {
    protected Class<E> enumClass;

    public EnumParameter(OptionID optionID, Class<E> enumClass, E defaultValue) {
        super(optionID, defaultValue);
        this.enumClass = enumClass;
    }

    public EnumParameter(OptionID optionID, Class<E> enumClass) {
        super(optionID);
        this.enumClass = enumClass;
    }

    @Override
    public String getSyntax() {
        return "<" + this.joinEnumNames(" | ") + ">";
    }

    @Override
    protected E parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (this.enumClass.isInstance(obj)) {
            return (E)((Enum)this.enumClass.cast(obj));
        }
        if (obj instanceof String) {
            try {
                return Enum.valueOf(this.enumClass, (String)obj);
            }
            catch (IllegalArgumentException ex) {
                throw new WrongParameterValueException("Enum parameter " + this.getOptionID().getName() + " is invalid (must be one of [" + this.joinEnumNames(", ") + "].");
            }
        }
        throw new WrongParameterValueException("Enum parameter " + this.getOptionID().getName() + " is not given as a string.");
    }

    @Override
    public String getValueAsString() {
        return ((Enum)this.getValue()).name();
    }

    @Override
    public StringBuilder describeValues(StringBuilder buf) {
        buf.append("One of:").append(FormatUtil.NEWLINE);
        for (String s : this.getPossibleValues()) {
            buf.append("->").append(FormatUtil.NONBREAKING_SPACE).append(s).append(FormatUtil.NEWLINE);
        }
        return buf;
    }

    public Collection<String> getPossibleValues() {
        Enum[] enums = (Enum[])this.enumClass.getEnumConstants();
        ArrayList<String> values = new ArrayList<String>(enums.length);
        for (Enum t : enums) {
            values.add(t.name());
        }
        return values;
    }

    private String joinEnumNames(String separator) {
        Enum[] enumTypes = (Enum[])this.enumClass.getEnumConstants();
        StringBuilder sb = new StringBuilder(enumTypes.length * 20);
        for (int i = 0; i < enumTypes.length; ++i) {
            sb.append(enumTypes[i].name()).append(separator);
        }
        sb.setLength(Math.max(0, sb.length() - separator.length()));
        return sb.toString();
    }

    public boolean grab(Parameterization config, Consumer<E> consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept((Enum)this.getValue());
            }
            return true;
        }
        return false;
    }
}

