/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.io.ParseUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.NumberParameter;
import java.util.function.DoubleConsumer;

public class DoubleParameter
extends NumberParameter<DoubleParameter, Double> {
    public DoubleParameter(OptionID optionID, double defaultValue) {
        super(optionID, defaultValue);
    }

    public DoubleParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Double)this.getValue()).toString();
    }

    @Override
    protected Double parseValue(Object obj) throws WrongParameterValueException {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            return ParseUtil.parseDouble(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a double value, read: " + obj + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<double>";
    }

    public double doubleValue() {
        return (Double)this.getValue();
    }

    public boolean grab(Parameterization config, DoubleConsumer consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept(this.doubleValue());
            }
            return true;
        }
        return false;
    }
}

