/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.logging.Logging;
import elki.utilities.ClassGenericsUtil;
import elki.utilities.ELKIServiceRegistry;
import elki.utilities.ELKIServiceScanner;
import elki.utilities.exceptions.ClassInstantiationException;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class ClassParameter<C>
extends AbstractParameter<ClassParameter<C>, Class<? extends C>> {
    private static final Logging LOG = Logging.getLogger(ClassParameter.class);
    protected Class<C> restrictionClass;

    public ClassParameter(OptionID optionID, Class<?> restrictionClass, Class<?> defaultValue) {
        super(optionID, defaultValue);
        this.restrictionClass = restrictionClass;
        if (restrictionClass == null) {
            LOG.warning((CharSequence)("Restriction class 'null' for parameter '" + optionID + "'"), new Throwable());
        }
    }

    public ClassParameter(OptionID optionID, Class<?> restrictionClass) {
        super(optionID);
        this.restrictionClass = restrictionClass;
        if (restrictionClass == null) {
            LOG.warning((CharSequence)("Restriction class 'null' for parameter '" + optionID + "'"), new Throwable());
        }
    }

    @Override
    protected Class<? extends C> parseValue(Object obj) throws ParameterException {
        Class<C> clz;
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof String && (clz = ELKIServiceRegistry.findImplementation(this.restrictionClass, (String)obj)) != null) {
            return clz;
        }
        throw new WrongParameterValueException(this, obj.toString(), "Class not found for given value. Must be a subclass / implementation of " + this.restrictionClass.getName());
    }

    @Override
    public boolean validate(Class<? extends C> obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (!this.restrictionClass.isAssignableFrom(obj)) {
            throw new WrongParameterValueException(this, obj.getName(), "Given class not a subclass / implementation of " + this.restrictionClass.getName());
        }
        return super.validate(obj);
    }

    @Override
    public String getSyntax() {
        return "<class>";
    }

    @Override
    public StringBuilder describeValues(StringBuilder buf) {
        return ClassParameter.describeImplementations(buf, this.restrictionClass, this.getKnownImplementations());
    }

    protected static StringBuilder describeImplementations(StringBuilder buf, Class<?> restrictionClass, List<Class<?>> imp) {
        if (restrictionClass == null || restrictionClass == Object.class) {
            return buf;
        }
        buf.append(restrictionClass.isInterface() ? "Implementing " : "Extending ").append(restrictionClass.getName()).append(FormatUtil.NEWLINE);
        if (!imp.isEmpty()) {
            String pkgName = restrictionClass.getPackage().getName();
            buf.append("Known classes (default package ").append(pkgName).append("):").append(FormatUtil.NEWLINE);
            Class[] known = imp.toArray(new Class[imp.size()]);
            Arrays.sort(known, ELKIServiceScanner.SORT_BY_NAME);
            for (Class c : known) {
                String name = c.getName();
                boolean stripPrefix = name.length() > pkgName.length() && name.startsWith(pkgName) && name.charAt(pkgName.length()) == '.';
                buf.append("->").append(FormatUtil.NONBREAKING_SPACE).append(name, stripPrefix ? pkgName.length() + 1 : 0, name.length()).append(FormatUtil.NEWLINE);
            }
        }
        return buf;
    }

    @Override
    public String getValueAsString() {
        return ClassParameter.canonicalClassName((Class)this.getValue(), this.getRestrictionClass());
    }

    @Override
    public String getDefaultValueAsString() {
        return ClassParameter.canonicalClassName((Class)this.getDefaultValue(), this.getRestrictionClass());
    }

    public static String canonicalClassName(Class<?> c, Package pkg) {
        String name = c.getName();
        if (pkg != null) {
            String pkgname = pkg.getName();
            if (name.length() > pkgname.length() && name.startsWith(pkgname) && name.charAt(pkgname.length()) == '.') {
                name = name.substring(pkgname.length() + 1);
            }
        }
        if (name.endsWith("$Factory")) {
            name = name.substring(0, name.length() - "$Factory".length());
        }
        return name;
    }

    public static String canonicalClassName(Class<?> c, Class<?> parent) {
        return ClassParameter.canonicalClassName(c, parent == null ? null : parent.getPackage());
    }

    public C instantiateClass(Parameterization config) {
        if (this.getValue() == null) {
            config.reportError(new UnspecifiedParameterException(this));
            return null;
        }
        try {
            config = config.descend(this);
            return ClassGenericsUtil.tryInstantiate(this.restrictionClass, (Class)this.getValue(), config);
        }
        catch (ClassInstantiationException e) {
            config.reportError(new WrongParameterValueException(this, ((Class)this.getValue()).getCanonicalName(), "Error instantiating class.", e));
            return null;
        }
    }

    public Class<C> getRestrictionClass() {
        return this.restrictionClass;
    }

    public List<Class<?>> getKnownImplementations() {
        return ELKIServiceRegistry.findAllImplementations(this.getRestrictionClass());
    }

    public boolean grab(Parameterization config, Consumer<C> consumer) {
        if (config.grab(this)) {
            C x;
            if (consumer != null && (x = this.instantiateClass(config)) != null) {
                consumer.accept(x);
            }
            return true;
        }
        return false;
    }
}

