/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.utilities.ClassGenericsUtil;
import elki.utilities.ELKIServiceRegistry;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;
import elki.utilities.optionhandling.parameters.ListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class ClassListParameter<C>
extends ListParameter<ClassListParameter<C>, List<Class<? extends C>>> {
    protected Class<C> restrictionClass;

    public ClassListParameter(OptionID optionID, Class<?> restrictionClass) {
        super(optionID);
        this.restrictionClass = restrictionClass;
    }

    @Override
    public String getValueAsString() {
        return this.formatValue((List)this.getValue());
    }

    @Override
    public String getDefaultValueAsString() {
        return this.formatValue((List)this.getDefaultValue());
    }

    protected String formatValue(List<Class<? extends C>> val) {
        StringBuilder buf = new StringBuilder(50 + val.size() * 25);
        String pkgname = this.restrictionClass.getPackage().getName();
        for (Class<C> c : val) {
            String name;
            if (buf.length() > 0) {
                buf.append(",");
            }
            boolean stripPrefix = (name = c.getName()).length() > pkgname.length() && name.startsWith(pkgname) && name.charAt(pkgname.length()) == '.';
            buf.append(name, stripPrefix ? pkgname.length() + 1 : 0, name.length());
        }
        return buf.toString();
    }

    @Override
    protected List<Class<? extends C>> parseValue(Object obj) throws ParameterException {
        try {
            List l2 = (List)List.class.cast(obj);
            for (Object o : l2) {
                if (o instanceof Class) continue;
                throw new WrongParameterValueException("Wrong parameter format for parameter \"" + this.getOptionID().getName() + "\". Given list contains objects of different type!");
            }
            return l2;
        }
        catch (ClassCastException l2) {
            try {
                if (this.restrictionClass.isAssignableFrom((Class)obj)) {
                    return Arrays.asList((Class)obj);
                }
            }
            catch (ClassCastException l2) {
                // empty catch block
            }
            if (obj instanceof String) {
                String[] classes = SPLIT.split((String)obj);
                if (classes.length == 0) {
                    throw new WrongParameterValueException("Wrong parameter format! Given list of classes for parameter \"" + this.getOptionID().getName() + "\" is either empty or has the wrong format!");
                }
                ArrayList<Class<C>> cls = new ArrayList<Class<C>>(classes.length);
                for (String cl : classes) {
                    Class<C> clz = ELKIServiceRegistry.findImplementation(this.restrictionClass, cl);
                    if (clz == null) {
                        throw new WrongParameterValueException(this, (String)obj, "Class '" + cl + "' not found for given value. Must be a subclass / implementation of " + this.restrictionClass.getName());
                    }
                    cls.add(clz);
                }
                return cls;
            }
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a list of Class values!");
        }
    }

    @Override
    protected boolean validate(List<Class<? extends C>> obj) throws ParameterException {
        for (Class<C> cls : obj) {
            if (this.restrictionClass.isAssignableFrom(cls)) continue;
            throw new WrongParameterValueException(this, cls.getName(), "Class \"" + cls.getName() + "\" does not extend/implement restriction class " + this.restrictionClass + ".\n");
        }
        return super.validate(obj);
    }

    public Class<C> getRestrictionClass() {
        return this.restrictionClass;
    }

    public List<Class<?>> getKnownImplementations() {
        return ELKIServiceRegistry.findAllImplementations(this.getRestrictionClass());
    }

    @Override
    public String getSyntax() {
        return "<class_1,...,class_n>";
    }

    public List<C> instantiateClasses(Parameterization config) {
        config = config.descend(this);
        ArrayList<C> instances = new ArrayList<C>();
        if (this.getValue() == null) {
            config.reportError(new UnspecifiedParameterException(this));
            return instances;
        }
        for (Class cls : (List)this.getValue()) {
            try {
                instances.add(ClassGenericsUtil.tryInstantiate(this.restrictionClass, cls, config));
            }
            catch (Exception e) {
                config.reportError(new WrongParameterValueException(this, cls.getName(), e.getMessage(), e));
            }
        }
        return instances;
    }

    @Override
    public StringBuilder describeValues(StringBuilder buf) {
        return ClassParameter.describeImplementations(buf, this.restrictionClass, this.getKnownImplementations());
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    public boolean grab(Parameterization config, Consumer<List<? extends C>> consumer) {
        if (config.grab(this)) {
            if (consumer != null) {
                consumer.accept(this.instantiateClasses(config));
            }
            return true;
        }
        return false;
    }
}

