/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameters;

import elki.logging.LoggingUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.UnspecifiedParameterException;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameters.Parameter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractParameter<P extends AbstractParameter<P, T>, T>
implements Parameter<T> {
    protected final OptionID optionid;
    protected T defaultValue = null;
    private boolean defaultValueTaken = false;
    protected boolean optionalParameter = false;
    protected List<ParameterConstraint<? super T>> constraints;
    protected T givenValue = null;
    private T value;

    public AbstractParameter(OptionID optionID, T defaultValue) {
        this.optionid = optionID;
        this.optionalParameter = true;
        this.defaultValue = defaultValue;
    }

    public AbstractParameter(OptionID optionID) {
        this.optionid = optionID;
        this.optionalParameter = false;
        this.defaultValue = null;
    }

    public P setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        this.optionalParameter = true;
        return (P)this;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public boolean tryDefaultValue() throws UnspecifiedParameterException {
        if (this.hasDefaultValue()) {
            this.setValueInternal(this.defaultValue);
            this.defaultValueTaken = true;
            return true;
        }
        if (this.isOptional()) {
            return false;
        }
        throw new UnspecifiedParameterException(this);
    }

    public P setOptional(boolean opt) {
        this.optionalParameter = opt;
        return (P)this;
    }

    @Override
    public boolean isOptional() {
        return this.optionalParameter;
    }

    @Override
    public boolean tookDefaultValue() {
        return this.defaultValueTaken;
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public StringBuilder describeValues(StringBuilder description) {
        return description;
    }

    protected boolean validate(T obj) throws ParameterException {
        if (this.constraints != null) {
            for (ParameterConstraint<T> cons : this.constraints) {
                cons.test(obj);
            }
        }
        return true;
    }

    @Override
    public OptionID getOptionID() {
        return this.optionid;
    }

    @Override
    public void setValue(Object obj) throws ParameterException {
        T val;
        if (obj != null && this.validate(val = this.parseValue(obj))) {
            this.setValueInternal(val);
            return;
        }
        throw new InvalidParameterException("Value for option \"" + this.getOptionID().getName() + "\" did not validate: " + obj);
    }

    protected void setValueInternal(T val) {
        this.givenValue = val;
        this.value = this.givenValue;
    }

    @Override
    public final T getValue() {
        if (this.value == null) {
            LoggingUtil.warning((String)("Programming error: Parameter#getValue() called for unset parameter \"" + this.getOptionID().getName() + "\""), (Throwable)new Throwable());
        }
        return this.value;
    }

    @Override
    public final boolean isValid(Object obj) throws ParameterException {
        return obj != null && this.validate(this.parseValue(obj));
    }

    protected abstract T parseValue(Object var1) throws ParameterException;

    @Override
    public String getDefaultValueAsString() {
        return this.getDefaultValue().toString();
    }

    public P addConstraint(ParameterConstraint<? super T> constraint) {
        List<ParameterConstraint<Object>> list;
        if (this.constraints != null) {
            list = this.constraints;
        } else {
            this.constraints = new ArrayList<ParameterConstraint<T>>(2);
            list = this.constraints;
        }
        list.add(constraint);
        return (P)this;
    }

    @Override
    public List<ParameterConstraint<? super T>> getConstraints() {
        return this.constraints != null ? Collections.unmodifiableList(this.constraints) : Collections.emptyList();
    }
}

