/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameterization;

import elki.utilities.ClassGenericsUtil;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.parameters.Parameter;
import java.util.Collection;

public interface Parameterization {
    default public boolean grab(Parameter<?> opt) {
        try {
            return this.setValueForOption(opt) || opt.tryDefaultValue();
        }
        catch (ParameterException e) {
            this.reportError(e);
            return false;
        }
    }

    public boolean setValueForOption(Parameter<?> var1) throws ParameterException;

    public Collection<ParameterException> getErrors();

    public void reportError(ParameterException var1);

    public boolean hasUnusedParameters();

    default public Parameterization descend(Object option) {
        return this;
    }

    default public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    default public <C> C tryInstantiate(Class<C> c) {
        try {
            return ClassGenericsUtil.tryInstantiate(c, c, this);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.reportError(new ParameterException("Error instantiating internal class: " + c.getName() + " " + (msg != null ? msg : e.getClass().getName()), e));
            return null;
        }
    }
}

