/*
 * Decompiled with CFR 0.152.
 */
package elki.utilities.optionhandling.parameterization;

import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.parameterization.ListParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MergedParameterization
implements Parameterization {
    private final Parameterization inner;
    private final ListParameterization current;
    private final List<ListParameterization.ParameterPair> used;

    public MergedParameterization(Parameterization child) {
        this.inner = child;
        this.current = new ListParameterization();
        this.used = new ArrayList<ListParameterization.ParameterPair>();
    }

    private MergedParameterization(Parameterization inner, ListParameterization current, List<ListParameterization.ParameterPair> used) {
        this.inner = inner;
        this.current = current;
        this.used = used;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() {
        List<ListParameterization.ParameterPair> list = this.used;
        synchronized (list) {
            for (ListParameterization.ParameterPair pair : this.used) {
                this.current.addParameter(pair);
            }
            this.used.clear();
        }
    }

    @Override
    public boolean setValueForOption(Parameter<?> opt) throws ParameterException {
        try {
            if (this.current.setValueForOption(opt)) {
                this.used.add(new ListParameterization.ParameterPair(opt.getOptionID(), opt.getValue()));
                return true;
            }
        }
        catch (ParameterException e) {
            this.current.reportError(e);
        }
        if (this.inner.setValueForOption(opt)) {
            this.used.add(new ListParameterization.ParameterPair(opt.getOptionID(), opt.getValue()));
            return true;
        }
        this.used.add(new ListParameterization.ParameterPair(opt.getOptionID(), opt.getDefaultValue()));
        return false;
    }

    @Override
    public Parameterization descend(Object option) {
        return new MergedParameterization(this.inner.descend(option), this.current.descend(option), this.used);
    }

    @Override
    public Collection<ParameterException> getErrors() {
        return this.current.getErrors();
    }

    @Override
    public void reportError(ParameterException e) {
        this.inner.reportError(e);
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.inner.hasUnusedParameters();
    }
}

